<?php
/**
 * Plugin Name: Panelhelper Premium - SMM Panel API tool
 * Update URI: false
 * Version: 2.9.0
 * Description: Integrate your SMM panel API to your wordpress store.
 * Author: Appalify
 * Author URI: https://appalify.com/panelhelper/
 * Requires at least: 4.0
 * Tested up to: 6.7.1
 *
 * License URI:  https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * License:      GPL v2 or later
 * Text Domain: panelhelper
 * Domain Path: /lang/
 *
 * @package WordPress
 * @author Appalify
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Load plugin class files.
require_once 'includes/class-panelhelper.php';
require_once 'includes/class-panelhelper-settings.php';

// Load plugin libraries.
require_once 'includes/lib/class-panelhelper-admin-api.php';
require_once 'includes/lib/class-panelhelper-post-type.php';
require_once 'includes/lib/class-panelhelper-taxonomy.php';

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );


function panelhelper_update_database() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'panelhelper_api_servers';

    // Check if the 'BALANCE' column exists
    $column_exists = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'BALANCE'");
    
    if (empty($column_exists)) {
        // The 'BALANCE' column does not exist, so we need to add it
        $sql = "ALTER TABLE $table_name ADD BALANCE DOUBLE";
        $wpdb->query($sql);
    }
}
function panelhelper_plugin_update() {
    $pnh_db_update = get_option('ph_db_update_check4');
    
    if ($pnh_db_update != 'done'){
    panelhelper_update_database();
    panelhelper_update_database_mainserver();
    update_option('ph_db_update_check4', 'done');
    
    }
}


function panelhelper_update_database_mainserver() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'panelhelper_api_servers';

    // Check if the 'BALANCE' column exists
    $column_exists = $wpdb->get_results("SHOW COLUMNS FROM $table_name LIKE 'MAIN'");
    
    if (empty($column_exists)) {
        // The 'BALANCE' column does not exist, so we need to add it
        $sql = "ALTER TABLE $table_name ADD MAIN INT(1) DEFAULT 0";
        $wpdb->query($sql);
    }
}

add_action( 'plugins_loaded', 'panelhelper_plugin_update' );

/**
 * Returns the main instance of panelhelper to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return object panelhelper
 */
function panelhelper() {
	$instance = panelhelper::instance( __FILE__, '2.9.0' );

	if ( is_null( $instance->settings ) ) {
		$instance->settings = panelhelper_Settings::instance( $instance );
	}

	return $instance;
}

panelhelper();
$plugin_dir = plugin_dir_path(__FILE__);
$updater_doc = $plugin_dir . 'includes/admin/premium/class-panelhelper-premium-check.php';

class panelhelper_update{

    public $plugin_slug;
    public $version;
    public $cache_key;
    public $cache_allowed;

    public function __construct() {

        $this->plugin_slug = 'panelhelper';
        $this->version = '2.9.0';
        $this->cache_key = 'panelhelper';
        $this->cache_allowed = true;

        add_filter( 'plugins_api', array( $this, 'info' ), 20, 3 );
        add_filter( 'site_transient_update_plugins', array( $this, 'update' ) );
        add_action( 'upgrader_process_complete', array( $this, 'purge' ), 10, 2 );

    }

    public function request(){
        $remote = get_transient( $this->cache_key );

        if( false === $remote || ! $this->cache_allowed ) {

            $remote = wp_remote_get(
                'http://api.appalify.com/get_update/plugin-panelhelper.json',
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Accept' => 'application/json'
                    )
                )
            );

            if(
                is_wp_error( $remote )
                || 200 !== wp_remote_retrieve_response_code( $remote )
                || empty( wp_remote_retrieve_body( $remote ) )
            ) {
                return false;
            }

            set_transient( $this->cache_key, $remote, DAY_IN_SECONDS );

        }

        $remote = json_decode( wp_remote_retrieve_body( $remote ) );

        return $remote;

    }


    function info( $res, $action, $args ) {

        // print_r( $action );
        // print_r( $args );

        // do nothing if you're not getting plugin information right now
        if( 'plugin_information' !== $action ) {
            return $res;
        }

        // do nothing if it is not our plugin
        if( $this->plugin_slug !== $args->slug ) {
            return $res;
        }

        // get updates
        $remote = $this->request();

        if( ! $remote ) {
            return $res;
        }

        $res = new stdClass();

        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_profile;
        $res->download_link = $remote->download_url;
        $res->trunk = $remote->download_url;
        $res->requires_php = $remote->requires_php;
        $res->last_updated = $remote->last_updated;

        $res->sections = array(
            'description' => $remote->sections->description,
            'installation' => $remote->sections->installation,
            'changelog' => $remote->sections->changelog
        );

        if( ! empty( $remote->banners ) ) {
            $res->banners = array(
                'low' => $remote->banners->low,
                'high' => $remote->banners->high
            );
        }

        return $res;

    }

    public function update( $transient ) {
        
        if ( empty($transient->checked ) ) {
            return $transient;
        }

        $remote = $this->request();

        if(
            $remote
            && version_compare( $this->version, $remote->version, '<' )
            && version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
            && version_compare( $remote->requires_php, PHP_VERSION, '<' )
        ) {        
            $res = new stdClass();
            $res->slug = $this->plugin_slug;
            $res->plugin = plugin_basename( __FILE__ ); 
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;

            $transient->response[ $res->plugin ] = $res;

    }

        return $transient;

    }

    public function purge( $upgrader, $options ){

        if (
            $this->cache_allowed
            && 'update' === $options['action']
            && 'plugin' === $options[ 'type' ]
        ) {
            // just clean the cache when new plugin version is installed
            delete_transient( $this->cache_key );
        }

    }


}
if (file_exists($updater_doc)) {
new panelhelper_update();
}
