<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_filter('woocommerce_add_cart_item_data', 'panelhelper_save_comment_field_value', 10, 2);
add_filter('woocommerce_get_item_data', 'panelhelper_display_comment_field_on_cart_and_checkout', 10, 2);
add_action('woocommerce_single_product_summary', 'panelhelper_display_comment_field_on_product_page', 6);
add_action('woocommerce_add_order_item_meta', 'panelhelper_save_comment_field_to_order_meta_data', 10, 3);

function panelhelper_check_and_add_comment_actions() {
    
    $api_comment_enabled = get_post_meta(get_the_ID(), 'panelhelper_api_comment_enabled', true);

    if ($api_comment_enabled === 'yes') {
        
        add_action('woocommerce_before_add_to_cart_button', 'panelhelper_add_custom_comment_field');
    }
}add_action('wp', 'panelhelper_check_and_add_comment_actions');


//add field to wc page

function panelhelper_add_custom_comment_field() {
    global $post;
    $custom_title = get_post_meta($post->ID, 'panelhelper_cc_title', true);
    
    // Generate nonce field
    wp_nonce_field( 'ph_comment_field_nonce', 'ph_comment_field_nonce' );

    echo '<div class="custom-input-field">';
    echo '<label for="panelhelper_userinput">' . esc_html($custom_title) . ': </label>';
    echo '<br>';
    echo '<textarea id="ph_comment_field" name="ph_comment_field" rows="5" cols="40"></textarea>';
    echo '</div>';
}

//save field on wc

function panelhelper_save_comment_field_value($cart_item_data, $product_id) {
    if (isset($_POST['ph_comment_field']) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['ph_comment_field_nonce'] )), 'ph_comment_field_nonce' )) {
        // Capture the raw input, remove slashes, and sanitize while preserving line breaks
        $raw_input = wp_unslash( $_POST['ph_comment_field'] );
        $sanitized_value = wp_kses_post( $raw_input ); // Preserve line breaks

        // Save the sanitized value in the cart item data
        $cart_item_data['ph_comment_field'] = $sanitized_value;
        $cart_item_data['unique_key'] = md5(microtime() . wp_rand()); // Unique key for cart item
    }
    return $cart_item_data;
}


// Display custom field value on cart and checkout page

function panelhelper_display_comment_field_on_cart_and_checkout($cart_data, $cart_item) {
    $product_id = $cart_item['product_id']; // Assuming the product ID is available in the cart item.
    $custom_title = get_post_meta($product_id, 'panelhelper_cc_title', true);
    
    if ($custom_title && isset($cart_item['ph_comment_field'])) {
        // Convert line breaks into <br> tags for display purposes
        $cart_data[] = array(
            'name' => esc_html($custom_title),
            'value' => nl2br( esc_html( $cart_item['ph_comment_field'] ) )
        );
    }
    return $cart_data;
}


// Display custom field value on single product page


function panelhelper_display_comment_field_on_product_page() {
    global $product;
    
    $ph_custom_field_value = $product->get_meta('ph_comment_field');

    if (!empty($ph_custom_field_value)) {
        echo '<p>Your Value: ' . esc_html($ph_custom_field_value) . '</p>';
    }
}

// Save custom field value to order meta data
function panelhelper_save_comment_field_to_order_meta_data($item_id, $values, $cart_item_key) {
    if (isset($values['ph_custom_field'])) {
        wc_add_order_item_meta($item_id, 'Comment Field', $values['ph_comment_field']);
    }
}