<?php
/**
 * Settings class file.
 *
 * @package WordPress Plugin Template/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Settings class.
 */
class panelhelper_premium_email{
    public function save_meta_boxes() {
	}




function Panelhelper_send_email_on_failed_order($orderid) {
        $email = get_option('ph_email_notif', '');
        $subject = 'Panelhelper Order Canceled - Order ID: ' . $orderid;
        
        // Message body of the email
        $message = 'An order on your account (Order ID: ' . $orderid . ') was canceled.';
        
        // Headers (optional, you can add more headers if needed)
        $headers = array('Content-Type: text/html; charset=UTF-8');
        
        // Use wp_mail() to send the email
      wp_mail($email, $subject, $message, $headers);
        
       
       
    }

function Panelhelper_send_email_on_order_notstarted($orderid) {
      $email = get_option('ph_email_notif', '');
      $subject = 'Panelhelper Order Error - Order ID: ' . $orderid;
      
      // Message body of the email
      $message = 'An order on your account (Order ID: ' . $orderid . ') has recently failed due to an error, please check your SMM API ID or quantity. Check Panelhelper for more details.';
      
      // Headers (optional, you can add more headers if needed)
      $headers = array('Content-Type: text/html; charset=UTF-8');
      
      // Use wp_mail() to send the email
    wp_mail($email, $subject, $message, $headers);
      
     
     
  }

function Panelhelper_send_email_balance_limit() {
    $email = get_option('ph_email_notif', '');
    $balance_warning = get_option('balance_warning_value_ph', '');

    $subject = 'Panelhelper - Balance under set limit of $' . $balance_warning;
    
    // Message body of the email
    $message = 'Your balance is under the limit $' . $balance_warning . '. Please add funds to your account.';
    
    // Headers (optional, you can add more headers if needed)
    $headers = array('Content-Type: text/html; charset=UTF-8');
    
    // Use wp_mail() to send the email
  wp_mail($email, $subject, $message, $headers);
    
   
   
}

function Panelhelper_balance_helper() {
  global $wpdb;

  // Fetch the balance warning value from options
  $balance_warning = get_option('balance_warning_value_ph', 0);

  // Fetch the timestamp of the last email sent
  $last_email_time = get_option('panelhelper_last_email_time', 0);

  // Check if 12 hours have passed since the last email
  //$email_interval = 120; for test
  $email_interval = 12 * HOUR_IN_SECONDS;
  $current_time = time();

  // Check if enough time has passed (12 hours) since the last email
  if (($current_time - $last_email_time) < $email_interval) {
      // If it's been less than 12 hours, exit early and don't send an email
      return;
  }

  // Get the servers from the database
  $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}panelhelper_api_servers");

  // Initialize a flag to track if an email needs to be sent
  $send_email = false;

  // Loop through each server and check its balance
  foreach ($results as $row) {
      $api_key = $row->API_KEY;
      $api_url = $row->API_URL;

      // Fetch the balance using the API
      if (strpos($api_url, 'http') === 0) {
          $api = new panelhelper_api_adder(); // Replace with actual API client class
          $balance = $api->api_balance($api_key, $api_url); // Fetch the balance from the API

          // Check if the balance is valid
          if (!empty($balance->balance)) {
              // Check if balance is below the warning threshold
              if ($balance->balance < $balance_warning) {
                  // Set the flag to true, indicating an email should be sent
                  $send_email = true;
                  break; // No need to check further if at least one server is below the threshold
              }
          }
      }
  }

  // If we found any server with a low balance and 12 hours have passed, send an email
  if ($send_email) {
      $this->Panelhelper_send_email_balance_limit(); // Call the email function to send a warning
      
      // Update the last email sent time
      update_option('panelhelper_last_email_time', $current_time);
  }
}

}