<?php
/**
 * Settings class file.
 *
 * @package WordPress Plugin Template/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$plugin_dir = plugin_dir_path(__FILE__);
$updater_doc = $plugin_dir . 'updater.php';

//include_once $updater_doc;
/**
 * Settings class.
 */
class panelhelper_api_activator{
    public function save_meta_boxes() {
	}

//todo cronjob for 3h check and cronjob for hourly woocommerce order send

function settingspage(){
	$html = '';
	$html .= $this->email_verification_form();
	$html .= $this->update_woocomerce(); // title is in this
	$html .= $this->ph_link_validation_message();
	return $html;
}




    public function check_if_panelhelper_active(){	

		$email = get_option('panelhelper_validator');
		
		// API endpoint
		$url = 'https://api.appalify.com/Premium-check.php';
		
		// Initialize cURL session
		$ch = curl_init($url);
		
		// Set the cURL options
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "email=$email");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		// Execute the cURL session
		$response = curl_exec($ch);
		
		// Check for errors
		if(curl_errno($ch)){
			echo 'Curl error: ' . esc_attr(curl_error($ch));
		}
		
		// Close cURL session
		curl_close($ch);
		// Output the response
		update_option('check_if_panelhelper_active', $response);
		$this->get_panelhelper_api_stats();
		//get it like this: $response = get_option('check_if_panelhelper_active');

	}

	public function get_panelhelper_api_stats(){	

		$email = get_option('panelhelper_validator');
		
		// API endpoint
		$url = 'https://api.appalify.com/api/wordpress_get_usage.php';
		
		// Initialize cURL session
		$ch = curl_init($url);
		
		// Set the cURL options
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "email=$email");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		// Execute the cURL session
		$response = curl_exec($ch);
		
		// Check for errors
		if(curl_errno($ch)){
			echo 'Curl error: ' . esc_attr(curl_error($ch));
		}
		
		// Close cURL session
		curl_close($ch);
		// Output the response
		update_option('panelhelper_api_usage', $response);

		//get it like this: $response = get_option('check_if_panelhelper_active');

	}



    public function email_verification_form() {

		if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['button-cancel']) && wp_verify_nonce( sanitize_text_field( wp_unslash (  $_POST['button-cancel'])), 'button-cancel_nonce' ) ) {
			
			//once the button cancel is clicked 

			//call function to cancel
			$is_canceled = $this->cancel_sub();

			//if success call this, if not call support
			if ($is_canceled === "success"){
			update_option('panelhelper_premium_info', "canceled");
			} else{
				update_option('panelhelper_premium_info', "canceled_er");
			}
			
			// Reload the page after form submission
			$redirect_url = add_query_arg( array(
				'page' => 'panelhelper_settings',
				'tab' => 'Settings'
			), admin_url( 'admin.php' ) );
		
			wp_redirect($redirect_url);
			exit;

		}
	
        $response = get_option('check_if_panelhelper_active');
		$check_for_email = get_option('panelhelper_validator');
		if (trim($response) == "true") {
			$current_plan = "Premium";
		} else {
			$current_plan = "Standard";
		}
		

		// Check if the form is submitted
		if (isset($_POST['verify_email_premium_panelhelper']) && wp_verify_nonce( sanitize_text_field( wp_unslash (  $_POST['button-submit'])), 'button-submit_nonce' ) ) {
			$email = sanitize_text_field($_POST['verify_email_premium_panelhelper']);
			update_option('panelhelper_validator', $email);
			$this->check_if_panelhelper_active();
			$response = get_option('check_if_panelhelper_active');
		}

		
		if (empty($check_for_email) || trim($response) == 'false') {	
			//main function runs after button retry or if the email check is empty, or if plan isnt active
			$check_for_email = get_option('panelhelper_validator');
			if (trim($response) == 'false' && $check_for_email != "errorincheck"){
				//update_option('panelhelper_validator', $email);
				echo '<div class="notice notice-warning is-dismissible"><p>There is no premium plan connected to your previous attempt. Please try again.</p></div>';
				update_option('panelhelper_validator', "errorincheck");
			} 

			?>
		
			<form class="" action="" method="post" autocomplete="off">
				</form>
			<form class="panelhelper-premiumcheck-container" method="post">
			<label class="panelhelper-premiumcheck-plan-title">Current Plan: <?php echo esc_attr($current_plan); ?></label>
			<button class="panelhelper-premium-visit-button" onclick="window.location.href = 'https://appalify.com/panelhelper/';">Get Premium</button>
			<br><br><br>
			<label class="panelhelper-premiumcheck-verify-title">Verify Your Premium Access:</label><br>
				<div class="panelhelper-premiumcheck-email-form">
				<label for="verify_email_premium_panelhelper">Email:</label> 
				<input type="email" id="verify_email_premium_panelhelper" name="verify_email_premium_panelhelper" placeholder="Enter your email" required>
				<button type="submit" class="button-submit">Verify</button>
				<?php  wp_nonce_field( 'button-submit_nonce', 'button-submit' ); ?>
			</form>
			<?php
			update_option('panelhelper_premium_info', "new");


		} elseif (trim($response) == 'true') {
			$check_for_email = get_option('panelhelper_validator');
			if (trim($response) == "true") {
				$current_plan = "Premium";
			} else {
				$current_plan = "Standard";
			}
				// Save verified email to wp_options
				// Hide form and display success message
				$premium_info = get_option('panelhelper_premium_info');
				$email = get_option('panelhelper_validator');
				$ph_api_usage = get_option('panelhelper_api_usage');
				//echo "You are on the premium version with the email: $email. Please pass this email to support if you ever need help.";
				if($premium_info == 'canceled'){
					echo '<div class="notice notice-warning is-dismissible"><p>Your plan was canceled succesfully.</p></div>';
				} elseif($premium_info == 'canceled_er'){
					echo '<div class="notice notice-warning is-dismissible"><p>Error while canceling, please contact support with the email: ' . esc_attr($email) . ' to cancel manually.</p></div>';
				} else{
				?>
		
			<form class="" action="" method="post" autocomplete="off">
				</form>
			<form class="panelhelper-premiumcheck-container" method="post" onsubmit="return confirmCancel()">
			<label class="panelhelper-premiumcheck-plan-title" >Current Plan: <?php echo esc_attr($current_plan); ?></label> <br><br><br><br>
			<label class="panelhelper-premiumcheck-verified-title">You are on the <strong>premium version</strong> with the email: <br><br><strong><?php echo esc_attr($email); ?> </strong> 
			
			<br><label class="panelhelper-premiumcheck-verified-title"><strong>API Usage</strong>:<?php echo esc_attr($ph_api_usage); ?></label><br>

			<br><br><br>Please pass this email to support if you ever need help.</label><br>
			<br><br><br>
			
				<button type="submit" class="button-submit">cancel plan</button>
				<?php  wp_nonce_field( 'button-cancel_nonce', 'button-cancel' ); ?>
			</form>

			<script>
    			function confirmCancel() {
        			return confirm("Are you sure you want to cancel your premium subscription?");
    			}
			</script>

			<?php
				}
				return;
			}




	}

	public function cancel_sub(){
	
	
	
		$email = get_option('panelhelper_validator');
		$url = 'https://api.appalify.com/paddle_customer_rm_request.php';
		
			$args = array(
				'body' => array(
					'email' => $email,
				),
			);
			
			$response = wp_remote_post($url, $args);

		return  $body = wp_remote_retrieve_body($response);
	}
	public function securely_check_api_server($orderprice){

		$is_valid = get_option('panelhelper_validator');
		$url = 'https://api.appalify.com/api_order_status.php';
		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
			'email' => $is_valid,
			'order' => $orderprice
		)));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		
		$api_status_response = curl_exec($ch);
		
		
		curl_close($ch);

	}

	public function update_woocomerce(){
		
			?>
				<form class="" action="" method="post" autocomplete="off">
				</form>
				<br>
				<a href="https://appalify.com/plugin-support/" style="text-decoration: none;">
					 <button style="background-color: #50C878; color: white; font-size: 16px; padding: 10px 20px; border-radius: 7px; border: none; cursor: pointer !important; margin-bottom: 50px;">
						Request new feature or report a bug
					  </button>
				</a>

			<?php
			
		
		$api_service_enabled = get_option('panelhelper_wc_updater');


		?>
		<br><titletagph class="panelhelper-title">Premium Settings</titletagph><br>



		<br><br>
		<form class="" action="" method="post" autocomplete="off">
            </form>
		<form id="myForm" method="post">
		
                <strong style="font-size: 16px; margin-right: 5px;">WC update order status</strong>
            
		<input type="checkbox" name="panelhelper_wc_updater" id="panelhelper_wc_updater" <?php checked($api_service_enabled, true); ?>>
            <?php  wp_nonce_field( 'panelhelper_wc_updater_nonce', 'panelhelper_wc_updater' ); ?>
		</form>
		<br>This will set your Woocommerce orders to completed, once your API order is marked as completed.




		<script>
  			document.getElementById('panelhelper_wc_updater').addEventListener('change', function() {
   			document.getElementById('myForm').submit();
 			 });

		</script>
		<?php
		if (isset($_POST['panelhelper_wc_updater']) && wp_verify_nonce( sanitize_text_field( wp_unslash (  $_POST['panelhelper_wc_updater'])), 'panelhelper_wc_updater_nonce' ) ) {
		if ($api_service_enabled ==false){
			$panelhelper_wc_updater2 = true;
			update_option('panelhelper_wc_updater', $panelhelper_wc_updater2);
		} else{
			$panelhelper_wc_updater2 = false;
			update_option('panelhelper_wc_updater', $panelhelper_wc_updater2);

		}

		$redirect_url = add_query_arg( array(
			'page' => 'panelhelper_settings',
			'tab' => 'Settings'
		), admin_url( 'admin.php' ) );

		wp_redirect($redirect_url);
		exit;
	}

	}
	public function ph_link_validation_message(){
			// Handle form submission
			if (isset($_POST['submit_social_settings'])) {
				if (!wp_verify_nonce($_POST['social_nonce'], 'save_social_settings')) {
					wp_die('Security check failed');
				}
		
				$selected_platform = sanitize_text_field($_POST['social_platform']);
				$message = sanitize_text_field($_POST['social_message']);
		
				if ($selected_platform === 'tiktok') {
					update_option('ph_tiktok_user_message', $message);
				} elseif ($selected_platform === 'instagram') {
					update_option('ph_instagram_user_message', $message);
				} elseif ($selected_platform === 'tiktok_post') {
					update_option('ph_tiktok_post_message', $message);
				} elseif ($selected_platform === 'instagram_post') {
					update_option('ph_instagram_post_message', $message);
				}  elseif ($selected_platform === 'invalid_link') {
					update_option('ph_invalid_link_message', $message);
				}
		
				// Update last selected platform
				update_option('ph_last_selected_social', $selected_platform);
		
				wp_redirect(add_query_arg([
					'page' => 'panelhelper_settings',
					'tab' => 'Settings',
					'updated' => '1'
				], admin_url('admin.php')));
				exit;
			}
		
			// Get current settings
			$last_selected = get_option('ph_last_selected_social', 'tiktok');
			$tiktok_msg = get_option('ph_tiktok_user_message', 'Please enter a valid username');
			$instagram_msg = get_option('ph_instagram_user_message', 'Please enter a valid username');
			$tiktok_post_msg = get_option('ph_tiktok_post_message', 'Please enter a valid Tiktok post link.');
			$instagram_post_msg = get_option('ph_instagram_post_message', 'Please enter a valid Instagram post link.');
			$invalid_link_msg = get_option('ph_invalid_link_message', 'Please enter a valid link.');
			
			$messages = [
				'tiktok' => $tiktok_msg,
				'instagram' => $instagram_msg,
				'tiktok_post' => $tiktok_post_msg,
				'instagram_post' => $instagram_post_msg,
				'invalid_link' => $invalid_link_msg
			];
			
			$current_message = $messages[$last_selected] ?? $tiktok_msg;
		
			?>
			<div class="wrap">
				<?php if (isset($_GET['updated'])) : ?>
					<div class="notice notice-success is-dismissible">
						<p>Settings saved successfully!</p>
					</div>
				<?php endif; ?>
		
				<form method="post">
					<?php wp_nonce_field('save_social_settings', 'social_nonce'); ?>
					
					<h3>User Input validation message</h3>
					
					<select name="social_platform" id="socialPlatform" style="margin-bottom: 15px;">
						<option value="tiktok" <?php selected($last_selected, 'tiktok'); ?>>TikTok Username</option>
						<option value="instagram" <?php selected($last_selected, 'instagram'); ?>>Instagram Username</option>
						<option value="tiktok_post" <?php selected($last_selected, 'tiktok_post'); ?>>TikTok Post</option>
						<option value="instagram_post" <?php selected($last_selected, 'instagram_post'); ?>>Instagram Post</option>
						<option value="invalid_link" <?php selected($last_selected, 'invalid_link'); ?>>Invalid</option>
					</select>
		
					<div id="messageField" style="margin: 20px 0;">
						<input type="text" name="social_message" value="<?php echo esc_attr($current_message); ?>" 
							   style="width: 300px; padding: 8px;" 
							   placeholder="Enter custom message...">
					</div>
		
					<button type="submit" name="submit_social_settings" 
							class="button button-primary" style="margin-top: 10px;">
						Save Settings
					</button>
				</form>
			</div>
		
			<script>
				(function() {
					const platformSelect = document.getElementById('socialPlatform');
					const messageInput = document.querySelector('[name="social_message"]');
					const messages = {
						tiktok: '<?php echo esc_js($tiktok_msg); ?>',
						instagram: '<?php echo esc_js($instagram_msg); ?>',
						tiktok_post: '<?php echo esc_js($tiktok_post_msg); ?>',
						instagram_post: '<?php echo esc_js($instagram_post_msg); ?>',
						invalid_link: '<?php echo esc_js($invalid_link_msg); ?>'
					};
		
					platformSelect.addEventListener('change', function() {
						messageInput.value = messages[this.value];
					});
				})();
			</script>
			<?php
		}
		




	function wc_order_updater($orderid) {


		$wc_order = wc_get_order($orderid);
		$wc_order->update_status('completed');
	
	}

	function panelhelper_import_all($SERVER, $api_url){
		$api = new panelhelper_api_adder(); // Replace YourAPI with the actual class name or API client
        $services= $api->api_services($SERVER, $api_url);

		$json_response = '[
			{
				"service": 1,
				"name": "Followers",
				"type": "Default",
				"category": "First Category",
				"rate": "0.90",
				"min": "50",
				"max": "10000",
				"refill": true,
				"cancel": true
			},
			{
				"service": 2,
				"name": "Comments",
				"type": "Custom Comments",
				"category": "Second Category",
				"rate": "8",
				"min": "10",
				"max": "1500",
				"refill": false,
				"cancel": true
			}
		]';
		
		// Decode JSON response
		//$services = json_decode($json_response, true);

		foreach ($services as $service) {
			$SID = $service->service;
			$SNAME = $service->name;
			$MAXO = $service->max;
			$MINO = $service->min;
			$PRICE = $service->rate;
			
			if ($this->panelhelper_insert_values_into_custom_table($SID, $SNAME, $MAXO, $MINO, $PRICE, $SERVER)) {
				$added_count++;
			} else {
				$not_added_count++;
			}
		}

	}

	function panelhelper_insert_values_into_custom_table($SID, $SNAME, $MAXO, $MINO, $PRICE, $SERVER) {
		global $wpdb;
		
		
		// Check if the service already exists
		$existing_service = $wpdb->get_var($wpdb->prepare(
			"SELECT COUNT(*) FROM {$wpdb->prefix}panelhelper_api_services WHERE SERVICE_ID = %d AND API_KEY = %s",
			$SID, $SERVER
		));
		
		// If the service does not exist, insert it
		if ($existing_service == 0) {
			$wpdb->insert(
				"{$wpdb->prefix}panelhelper_api_services",
				array(
					'SERVICE_ID' => $SID,
					'SERVICE_NAME' => $SNAME,
					'MIN_ORDER' => $MINO,
					'MAX_ORDER' => $MAXO,
					'PRICE' => $PRICE,
					'API_KEY' => $SERVER,
				),
				array(
					'%d', // SERVICE_ID is an integer
					'%s', // SERVICE_NAME is a string
					'%d', // MIN_ORDER is an integer
					'%d', // MAX_ORDER is an integer
					'%f', // PRICE is a float
					'%s', // API_KEY is a string
				)
			);
			return true; // Successfully added
		} else {
			return false; // Already exists
		}
	}






	




}