<?php
defined( 'ABSPATH' ) || exit;

// Pagination
// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
$paged        = isset( $_GET['subpage'] ) ? max( 1, absint( $_GET['subpage'] ) ) : 1;
$per_page     = 10;
$easysubs_offset       = ( $paged - 1 ) * $per_page;
$easysubs_customer_id  = get_current_user_id();

// Query subscription orders
$easysubs_list_args = [
    'customer_id' => $easysubs_customer_id,
    'limit'       => $per_page,
    'offset'      => $easysubs_offset,
    'status'      => [ 'wc-completed', 'wc-processing' ],
    'meta_query' => [
        [
            'key'     => '_easy_subscriptions_scheduled',
            'value'   => 'yes',
            'compare' => '=',
        ],
        ],
];
$easysubs_orders = wc_get_orders( $easysubs_list_args );

// Total for pagination
$easysubs_count_args          = $easysubs_list_args;
$easysubs_count_args['return'] = 'ids';
$easysubs_count_args['limit']  = -1;
$easysubs_count_args['offset'] = 0;
$easysubs_total_ids           = wc_get_orders( $easysubs_count_args );
$easysubs_total               = is_array( $easysubs_total_ids ) ? count( $easysubs_total_ids ) : 0;
$easysubs_max_pages           = max( 1, (int) ceil( $easysubs_total / $per_page ) );

$easysubs_base_url = wc_get_account_endpoint_url( 'easy-subscriptions' );
$easysubs_base_url = remove_query_arg( [ 'subpage' ], $easysubs_base_url );
?>

<table class="shop_table shop_table_responsive my_account_orders">
<thead>
    <tr>
        <th class="order-number"><span class="nobr"><?php esc_html_e( 'Order', 'easy-subscriptions' ); ?></span></th>
        <th class="order-date"><span class="nobr"><?php esc_html_e( 'Start Date', 'easy-subscriptions' ); ?></span></th>
        <th class="order-item"><span class="nobr"><?php esc_html_e( 'Item', 'easy-subscriptions' ); ?></span></th>
        <th class="order-status"><span class="nobr"><?php esc_html_e( 'Status', 'easy-subscriptions' ); ?></span></th>
        <th class="order-payment"><span class="nobr"><?php esc_html_e( 'Payment Method', 'easy-subscriptions' ); ?></span></th>
        <th class="order-actions">&nbsp;</th>
    </tr>
</thead>
<tbody>
<?php if ( empty( $easysubs_orders ) ) : ?>
    <tr>
        <td colspan="6">
            <?php esc_html_e( 'You have no active subscriptions.', 'easy-subscriptions' ); ?>
        </td>
    </tr>
<?php else : ?>
    <?php foreach ( $easysubs_orders as $order ) : ?>
        <?php
        $easysubs_order_id = $order->get_id();
        $easysubs_edit_url = $order->get_view_order_url();

        // Build payment method URL once per order
        $easysubs_add_pm_url = wp_nonce_url(
            add_query_arg(
                [
                    'es_sub'    => $easysubs_order_id,
                    'es_return' => rawurlencode( wc_get_account_endpoint_url( 'easy-subscriptions' ) ),
                ],
                wc_get_endpoint_url( 'add-payment-method', '', wc_get_page_permalink( 'myaccount' ) )
            ),
            'easy_subs_capture',
            '_es_nonce'
        );

        foreach ( $order->get_items() as $easysubs_item ) {
            $easysubs_pid    = $easysubs_item->get_variation_id() ?: $easysubs_item->get_product_id();
            $easysubs_is_sub = get_post_meta( $easysubs_pid, '_easy_subscriptions', true );
            if ( $easysubs_is_sub !== 'yes' ) continue;

            $easysubs_item_name = $easysubs_item->get_name();
            $easysubs_qty       = (int) $easysubs_item->get_quantity();

            for ( $easysubs_i = 1; $easysubs_i <= $easysubs_qty; $easysubs_i++ ) :
                $easysubs_unit_status = function_exists( 'easy_subs_unit_status_myaccount' )
                    ? easy_subs_unit_status_myaccount( $easysubs_order_id, $easysubs_item->get_id(), $easysubs_i )
                    : 'active';

                $easysubs_cancel_url = wp_nonce_url(
                    add_query_arg(
                        [
                            'action'   => 'cancel_subscription',
                            'order_id' => $easysubs_order_id,
                            'item_id'  => $easysubs_item->get_id(),
                            'unit'     => $easysubs_i,
                        ],
                        $easysubs_base_url
                    ),
                    'cancel_subscription_' . $easysubs_order_id . '_' . $easysubs_item->get_id() . '_' . $easysubs_i
                );
                ?>
                <tr class="order">
                    <!-- Order number -->
                    <td class="order-number" data-title="<?php esc_attr_e( 'Order', 'easy-subscriptions' ); ?>">
                        <a href="<?php echo esc_url( $easysubs_edit_url ); ?>">#<?php echo esc_html( $order->get_order_number() ); ?></a>
                    </td>

                    <!-- Date -->
                    <td class="order-date" data-title="<?php esc_attr_e( 'Start Date', 'easy-subscriptions' ); ?>">
                        <?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?>
                    </td>

                    <!-- Item + unit -->
                    <td class="order-item" data-title="<?php esc_attr_e( 'Item', 'easy-subscriptions' ); ?>">
                        <?php echo esc_html( $easysubs_item_name ); ?>
                        <?php if ( $easysubs_qty > 1 ) echo ' (#' . esc_html( $easysubs_i ) . ')'; ?>
                    </td>

                    <!-- Status -->
                    <td class="order-status" data-title="<?php esc_attr_e( 'Status', 'easy-subscriptions' ); ?>">
                        <?php echo esc_html( ucfirst( $easysubs_unit_status ) ); ?>
                    </td>

                    <!-- Payment Method -->
                    <td class="order-payment" data-title="<?php esc_attr_e( 'Payment Method', 'easy-subscriptions' ); ?>">
                        <?php
                        $easysubs_method = get_post_meta( $easysubs_order_id, '_stripe_payment_method_title', true );
                        echo $easysubs_method ? esc_html( $easysubs_method ) : esc_html__( 'Not set', 'easy-subscriptions' );
                        ?>
                    </td>

                    <!-- Actions -->
                    <td class="order-actions">
                        <div class="easy-subs-actions" style="display:flex; gap:6px; flex-wrap:wrap;">
                            <a href="<?php echo esc_url( $easysubs_add_pm_url ); ?>"
                               class="woocommerce-button wp-element-button">
                               <?php esc_html_e( 'Update Payment Method', 'easy-subscriptions' ); ?>
                            </a>

                            <a href="<?php echo esc_url( $easysubs_edit_url ); ?>"
                               class="woocommerce-button wp-element-button">
                                <?php esc_html_e( 'View', 'easy-subscriptions' ); ?>
                            </a>

                            <?php if ( $easysubs_unit_status === 'active' ) : ?>
                                <a href="<?php echo esc_url( $easysubs_cancel_url ); ?>"
                                   class="woocommerce-button wp-element-button cancel"
                                   onclick="return confirm('<?php echo esc_js( __( 'Are you sure you want to cancel this subscription?', 'easy-subscriptions' ) ); ?>');">
                                    <?php esc_html_e( 'Cancel', 'easy-subscriptions' ); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            <?php endfor;
        } // items
    endforeach; ?>
<?php endif; ?>
</tbody>
</table>

<?php if ( $easysubs_max_pages > 1 ) : ?>
    <nav class="woocommerce-pagination">
        <?php
        echo wp_kses_post( paginate_links( [
        'base'      => esc_url_raw( add_query_arg( 'subpage', '%#%', $easysubs_base_url ) ),
        'format'    => '',
        'current'   => $paged,
        'total'     => $easysubs_max_pages,
        'prev_text' => '&larr;',
        'next_text' => '&rarr;',
        'type'      => 'list',
        ] ) );
        ?>
    </nav>
<?php endif; ?>