<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter( 'product_type_options', 'easy_subscriptions_add_product_type_option' );
add_filter( 'woocommerce_product_data_tabs', 'easy_subscriptions_add_product_data_tab_woo', 99, 1 );
add_action( 'easy_subscriptions_panel_content', 'easy_subscriptions_render_product_data_panel' );
add_action('woocommerce_product_after_variable_attributes','easy_subscriptions_render_product_data_panel', 10,3);



//Add "Subscriptions" next to Virtual / Downloadable.
function easy_subscriptions_add_product_type_option( $options ) {
    $screen = get_current_screen();
    if ( $screen && 'product' === $screen->id ) {
        $post_id = isset( $_GET['post'] ) ? absint( wp_unslash( $_GET['post'] ) ) : 0;

        if ( $post_id && isset( $_GET['_wpnonce'] ) &&
             wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ), 'update-post_' . $post_id )
        ) {
            $product = wc_get_product( $post_id );
            if ( $product && 'variable' === $product->get_type() ) {
                return $options;
            }
        }
    }
    $options['easy_subscriptions'] = array(
        'id'            => '_easy_subscriptions', // becomes the input name/id
        'wrapper_class' => 'show_if_simple show_if_grouped show_if_external',
        'label'         => __( 'Subscriptions', 'easy-subscriptions' ),
        'description'   => __( 'Enable subscriptions for this product.', 'easy-subscriptions' ),
        'default'       => 'no',
    );
    return $options;
}



//Show the "Easy Subscriptions" tab ONLY when enabled.
function easy_subscriptions_add_product_data_tab_woo( $tabs ) {
    // Always register the tab; visibility is controlled via the show_if_easy_subscriptions class & JS.
    $tabs['Easy Subscriptions'] = array(
        'label'  => __( 'Easy Subscriptions', 'easy-subscriptions' ),
        'target' => 'easy_subscriptions_ps_setup',
        'class'  => array( 'show_if_easy_subscriptions', 'easy_subscriptions_ps_setup' ),
    );

    return $tabs;
}



// Render the panel for the Easy Subscriptions tab or for variations.
function easy_subscriptions_render_product_data_panel( $loop = null, $variation_data = null, $variation = null ) {
    $post_id = $variation ? $variation->ID : get_the_ID();

    $period_interval   = get_post_meta( $post_id, '_easy_subscriptions_period_interval', true );
    $period_unit       = get_post_meta( $post_id, '_easy_subscriptions_period_unit', true );

    $trial_length      = get_post_meta( $post_id, '_easy_subscriptions_trial_length', true );
    $trial_unit        = get_post_meta( $post_id, '_easy_subscriptions_trial_unit', true );

    $additional_fee    = get_post_meta( $post_id, '_easy_subscriptions_additional_fee', true );

    $ends              = get_post_meta( $post_id, '_easy_subscriptions_ends', true );
    $end_date          = get_post_meta( $post_id, '_easy_subscriptions_end_date', true );

    $one_time          = get_post_meta( $post_id, '_easy_subscriptions_one_time', true );

    $separate_shipping = get_post_meta( $post_id, '_easy_subscriptions_separate_shipping', true );
    $shipping_interval = get_post_meta( $post_id, '_easy_subscriptions_shipping_interval', true );
    $shipping_unit     = get_post_meta( $post_id, '_easy_subscriptions_shipping_unit', true );
    $shipping_sync     = get_post_meta( $post_id, '_easy_subscriptions_shipping_sync', true );
    ?>
    <div class="options_group">

        <!-- Subscription Period -->
        <p class="form-field">
            <label for="_easy_subscriptions_period_interval"><?php esc_html_e( 'Subscription period', 'appalify-subscriptions-for-woocommerce' ); ?></label>
            <input
                type="number"
                name="_easy_subscriptions_period_interval<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>"
                value="<?php echo esc_attr( $period_interval ? $period_interval : 1 ); ?>"
                min="1"
                style="width:60px; margin-right:10px;"
            />
            <select
                name="_easy_subscriptions_period_unit<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>"
                style="vertical-align:middle;"
            >
                <option value="day"   <?php selected( $period_unit, 'day' ); ?>><?php esc_html_e( 'Days', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="week"  <?php selected( $period_unit, 'week' ); ?>><?php esc_html_e( 'Weeks', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="month" <?php selected( $period_unit, 'month' ); ?>><?php esc_html_e( 'Months', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="year"  <?php selected( $period_unit, 'year' ); ?>><?php esc_html_e( 'Years', 'appalify-subscriptions-for-woocommerce' ); ?></option>
            </select>
        </p>
        <h2><?php esc_html_e( 'Premium settings', 'appalify-subscriptions-for-woocommerce' ); ?></h2>
        <!-- Free Trial -->
        <p class="form-field">
            <label><?php esc_html_e( 'Free trial ', 'appalify-subscriptions-for-woocommerce' ); ?></label>
      
        <span class="woocommerce-help-tip" data-tip="<?php esc_html_e( 'Important for PayPal: The trial period must match the subscription interval type. For example, if your subscription is monthly, your free trial must also be set in months (1, 2, 3... months). You cannot set a 7-day trial for a monthly subscription.', 'appalify-subscriptions-for-woocommerce' ); ?>"></span>

            <input
                type="number"
                name="_easy_subscriptions_trial_length<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>"
                value="<?php echo esc_attr( $trial_length ? $trial_length : 0 ); ?>"
                min="0"
                style="width:60px; margin-right:10px;"
            />
            <select name="_easy_subscriptions_trial_unit<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>">
                <option value="day"   <?php selected( $trial_unit, 'day' ); ?>><?php esc_html_e( 'Days', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="week"  <?php selected( $trial_unit, 'week' ); ?>><?php esc_html_e( 'Weeks', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="month" <?php selected( $trial_unit, 'month' ); ?>><?php esc_html_e( 'Months', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                <option value="year"  <?php selected( $trial_unit, 'year' ); ?>><?php esc_html_e( 'Years', 'appalify-subscriptions-for-woocommerce' ); ?></option>
            </select>
        </p>

        <!-- Additional Fee -->
        <p class="form-field">
            <label for="_easy_subscriptions_additional_fee"><?php esc_html_e( 'Additional fee', 'appalify-subscriptions-for-woocommerce' ); ?></label>
            <span><?php echo esc_html( get_woocommerce_currency_symbol() ); ?></span>
            <input
                type="number"
                step="0.01"
                placeholder="50"
                name="_easy_subscriptions_additional_fee<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>"
                value="<?php echo esc_attr( $additional_fee ); ?>"
                style="width:100px; margin-left:5px;"
            />
        </p>

        <!-- Subscription Ends -->
        <p class="form-field">
            <label><?php esc_html_e( 'Subscription ends', 'appalify-subscriptions-for-woocommerce' ); ?></label><br/>
            <label>
                <input type="radio" class="ends-radio" name="_easy_subscriptions_ends<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>" value="never" <?php checked( $ends, 'never' ); ?> />
                <?php esc_html_e( 'Never', 'appalify-subscriptions-for-woocommerce' ); ?>
            </label><br/>
            <label>
                <input type="radio" class="ends-radio" name="_easy_subscriptions_ends<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>" value="date" <?php checked( $ends, 'date' ); ?> />
                <?php esc_html_e( 'Set end date', 'appalify-subscriptions-for-woocommerce' ); ?>
            </label>
            <input type="date" class="end-date-field" name="_easy_subscriptions_end_date<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>" value="<?php echo esc_attr( $end_date ); ?>" style="margin-left:10px;" />
        </p>

        <!-- Offer one-time payment -->
        <p class="form-field">
            <label for="_easy_subscriptions_one_time"><?php esc_html_e( 'Offer one-time payment option', 'appalify-subscriptions-for-woocommerce' ); ?></label>
            <input type="checkbox" name="_easy_subscriptions_one_time<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>" value="yes" <?php checked( $one_time, 'yes' ); ?> />
        </p>

        <!-- Separate shipping cycles -->
        <p class="form-field">
            <label for="_easy_subscriptions_separate_shipping"><?php esc_html_e( 'Separate shipping cycles', 'appalify-subscriptions-for-woocommerce' ); ?></label>
            <input type="checkbox" class="separate-shipping-toggle" name="_easy_subscriptions_separate_shipping<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>" value="yes" <?php checked( $separate_shipping, 'yes' ); ?> />
        </p>

        <div class="separate-shipping-fields" style="margin-left:20px; <?php echo ( $separate_shipping === 'yes' ? '' : 'display:none;' ); ?>">
            <p class="form-field">
                <label><?php esc_html_e( 'Shipping frequency', 'appalify-subscriptions-for-woocommerce' ); ?></label>
                <input
                    type="number"
                    name="_easy_subscriptions_shipping_interval<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>"
                    value="<?php echo esc_attr( $shipping_interval ? $shipping_interval : 1 ); ?>"
                    min="1"
                    style="width:60px; margin-right:10px;"
                />
                <select name="_easy_subscriptions_shipping_unit<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>">
                    <option value="day"   <?php selected( $shipping_unit, 'day' ); ?>><?php esc_html_e( 'Days', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="week"  <?php selected( $shipping_unit, 'week' ); ?>><?php esc_html_e( 'Weeks', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="month" <?php selected( $shipping_unit, 'month' ); ?>><?php esc_html_e( 'Months', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="year"  <?php selected( $shipping_unit, 'year' ); ?>><?php esc_html_e( 'Years', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                </select>
            </p>
            <p class="form-field">
                <label><?php esc_html_e( 'Synchronise shipping frequency', 'appalify-subscriptions-for-woocommerce' ); ?></label>
                <select name="_easy_subscriptions_shipping_sync<?php echo $variation ? '[' . esc_attr( $variation->ID ) . ']' : ''; ?>">
                    <option value="off" <?php selected( $shipping_sync, 'off' ); ?>><?php esc_html_e( 'Off', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="monday" <?php selected( $shipping_sync, 'monday' ); ?>><?php esc_html_e( 'Monday each week', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="month" <?php selected( $shipping_sync, 'month' ); ?>><?php esc_html_e( 'First day of the month', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                    <option value="year" <?php selected( $shipping_sync, 'year' ); ?>><?php esc_html_e( 'First day of the year', 'appalify-subscriptions-for-woocommerce' ); ?></option>
                </select>
            </p>
        </div>
    </div>

    <?php
}


function easy_subscriptions_save_checkbox_value( $product ) {
    // Verify WooCommerce's product meta nonce first
    if (
        ! isset( $_POST['woocommerce_meta_nonce'] ) ||
        ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['woocommerce_meta_nonce'] ) ), 'woocommerce_save_data' )
    ) {
        return;
    }

    // Enable/disable subscription
    $enabled = isset( $_POST['_easy_subscriptions'] ) ? 'yes' : 'no';
    $product->update_meta_data( '_easy_subscriptions', $enabled );
    $product->update_meta_data( 'easy_subscriptions_', $enabled );

    // Subscription period
    if ( isset( $_POST['_easy_subscriptions_period_interval'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_period_interval', absint( wp_unslash( $_POST['_easy_subscriptions_period_interval'] ) ) );
    }
    if ( isset( $_POST['_easy_subscriptions_period_unit'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_period_unit', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_period_unit'] ) ) );
    }
    /** only on premium
    // Free trial
    if ( isset( $_POST['_easy_subscriptions_trial_length'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_trial_length', absint( wp_unslash( $_POST['_easy_subscriptions_trial_length'] ) ) );
    }
    if ( isset( $_POST['_easy_subscriptions_trial_unit'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_trial_unit', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_trial_unit'] ) ) );
    }

    // Additional fee
    if ( isset( $_POST['_easy_subscriptions_additional_fee'] ) ) {
        $fee_raw = sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_additional_fee'] ) );
        $product->update_meta_data( '_easy_subscriptions_additional_fee', wc_format_decimal( $fee_raw ) );
    }

    // Ends
    if ( isset( $_POST['_easy_subscriptions_ends'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_ends', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_ends'] ) ) );
    }
    if ( isset( $_POST['_easy_subscriptions_end_date'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_end_date', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_end_date'] ) ) );
    }

    // One-time payment
    $product->update_meta_data( '_easy_subscriptions_one_time', isset( $_POST['_easy_subscriptions_one_time'] ) ? 'yes' : 'no' );

    // Separate shipping
    $product->update_meta_data( '_easy_subscriptions_separate_shipping', isset( $_POST['_easy_subscriptions_separate_shipping'] ) ? 'yes' : 'no' );

    if ( isset( $_POST['_easy_subscriptions_shipping_interval'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_shipping_interval', absint( wp_unslash( $_POST['_easy_subscriptions_shipping_interval'] ) ) );
    }
    if ( isset( $_POST['_easy_subscriptions_shipping_unit'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_shipping_unit', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_shipping_unit'] ) ) );
    }
    if ( isset( $_POST['_easy_subscriptions_shipping_sync'] ) ) {
        $product->update_meta_data( '_easy_subscriptions_shipping_sync', sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_shipping_sync'] ) ) );
    }*/
}