<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'woocommerce_variation_options', 'easy_subscriptions_add_variation_checkbox', 10, 3 );
add_action( 'woocommerce_save_product_variation', 'easy_subscriptions_save_variation_checkbox', 10, 2 );


function easy_subscriptions_add_variation_checkbox( $loop, $variation_data, $variation ) {
    $enabled = get_post_meta( $variation->ID, '_easy_subscriptions', true );
    ?>
    <label class="tips" data-tip="<?php esc_html_e( 'Enable subscription for this variation.', 'easy-subscriptions' ); ?>">
        <input type="checkbox"
               class="checkbox variable_is_subscription"
               name="variable_easy_subscriptions[<?php echo esc_attr( $loop ); ?>]"
               <?php checked( $enabled, 'yes' ); ?> />
        <?php esc_html_e( 'Subscription', 'easy-subscriptions' ); ?>
    </label>
    <?php
}

function easy_subscriptions_save_variation_checkbox( $variation_id, $i ) {
    if ( ! isset( $_POST['_wpnonce'] ) || 
         ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'save-variations' ) ) {
        return;
    }

    $enabled = isset( $_POST['variable_easy_subscriptions'][ $i ] ) ? 'yes' : 'no';
    update_post_meta( $variation_id, '_easy_subscriptions', $enabled );
}



add_action( 'woocommerce_save_product_variation', function( $variation_id, $i ) {
    // phpcs:ignore WordPress.Security.NonceVerification.Missing
    $enabled = isset( $_POST['variable_easy_subscriptions'][ $i ] ) ? 'yes' : 'no';
    update_post_meta( $variation_id, '_easy_subscriptions', $enabled );

    // phpcs:ignore WordPress.Security.NonceVerification.Missing
    if ( isset( $_POST['_easy_subscriptions_period_interval'][ $variation_id ] ) ) {
        update_post_meta(
            $variation_id,
            '_easy_subscriptions_period_interval',
            // phpcs:ignore WordPress.Security.NonceVerification.Missing
            absint( wp_unslash( $_POST['_easy_subscriptions_period_interval'][ $variation_id ] ) )
        );
    }

    // phpcs:ignore WordPress.Security.NonceVerification.Missing
    if ( isset( $_POST['_easy_subscriptions_period_unit'][ $variation_id ] ) ) {
        update_post_meta(
            $variation_id,
            '_easy_subscriptions_period_unit',
            // phpcs:ignore WordPress.Security.NonceVerification.Missing
            sanitize_text_field( wp_unslash( $_POST['_easy_subscriptions_period_unit'][ $variation_id ] ) )
        );
    }
}, 10, 2 );