<?php
/**
 * Settings class file.
 *
 * @package WordPress Plugin Template/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}




$easy_subscriptions_plugin_dir = plugin_dir_path(__FILE__);

include_once $easy_subscriptions_plugin_dir . 'admin/class-admin-easy-subscriptions-settingspage.php';
include_once $easy_subscriptions_plugin_dir . 'admin/class-easy-subscriptions-admin-page.php';
include_once $easy_subscriptions_plugin_dir . 'admin/class-easy-subscriptions-assets.php';

include_once $easy_subscriptions_plugin_dir . 'integration/class-easy-subscriptions-payment-handling.php';
include_once $easy_subscriptions_plugin_dir . 'integration/product-settings/class-easy-subscriptions-product-settings.php';
include_once $easy_subscriptions_plugin_dir . 'integration/product-settings/class-easy-subscriptions-product-settings-helper.php';
include_once $easy_subscriptions_plugin_dir . 'integration/product-settings/class-easy-subscriptions-product-settings-variations.php';
include_once $easy_subscriptions_plugin_dir . 'integration/class-easy-subscriptions-my-account.php';
include_once $easy_subscriptions_plugin_dir . 'integration/class-easy-subscriptions-payment-update.php';
include_once $easy_subscriptions_plugin_dir . 'integration/class-easy-subscriptions-force-save-pm.php';


include_once $easy_subscriptions_plugin_dir . 'gateways/interface-easy-subscriptions-gateway.php';
include_once $easy_subscriptions_plugin_dir . 'gateways/class-easy-subscriptions-gateway-stripe.php';
include_once $easy_subscriptions_plugin_dir . 'gateways/class-easy-subscriptions-gateway-woopayments.php';
include_once $easy_subscriptions_plugin_dir . 'gateways/class-easy-subscriptions-gateway-paypal.php';
include_once $easy_subscriptions_plugin_dir . 'scheduler/class-easy-subscriptions-scheduler.php';







update_option('easy_subscriptions_repo_version', 1);

/**
 * Settings class.
 */

class easy_subscriptions_Settings {

	/**
	 * The single instance of easy_subscriptions_Settings.
	 *
	 * @var     object
	 * @access  private
	 * @since   1.0.0
	 */
	private static $_instance = null; //phpcs:ignore

	/**
	 * The main plugin object.
	 *
	 * @var     object
	 * @access  public
	 * @since   1.0.0
	 */
	public $parent = null;

	/**
	 * Prefix for plugin settings.
	 *
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $base = '';

	/**
	 * Available settings for plugin.
	 *
	 * @var     array
	 * @access  public
	 * @since   1.0.0
	 */
	public $settings = array();

	/**
	 * Constructor function.
	 *
	 * @param object $parent Parent object.
	 */
	public function __construct( $parent ) {
		$this->parent = $parent;
		$this->easy_subscriptions_include_files_late();

		$this->base = 'wpt_';


		// Register plugin settings.
		add_action( 'admin_init', array( $this, 'register_settings' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'easy_subscriptions_enqueue_admin_scripts' ) );

		add_filter('woocommerce_settings_tabs_array', array( $this, 'easy_subscriptions_woocommerce_settings_tab'), 50);
		add_action('woocommerce_settings_tabs_easy_subscriptions_tab',array( $this,  'easy_subscriptions_settings_page'));

		// Add settings link to plugins page.
		add_filter(
			'plugin_action_links_' . plugin_basename( $this->parent->file ),
			array(
				$this,
				'add_settings_link',
			)
		);

		// Configure placement of plugin settings page. See readme for implementation.
		//add_filter( $this->base . '2easy_subs_menu_settings', array( $this, 'configure_settings' ) );
	}
	public function easy_subscriptions_include_files_late() {

		/**
		 * Helper hook to include files late.
		 *
		 */
		do_action( 'easy_subscriptions_include_files_late_action' );

	}

public function easy_subscriptions_enqueue_admin_scripts( $hook ) {
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended
	if ((isset($_GET['tab']) && $_GET['tab'] === 'easy_subscriptions_tab') ||(isset($_GET['page']) && $_GET['page'] === 'easy-subscriptions') ) {
		wp_enqueue_style(
			'easy-subscriptions-admin',
			plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/admin.css',
			array(),
			'1.0.0'
		);

		// Optional inline fallback
		$custom_css = '.woocommerce-save-button.components-button.is-primary { display: none; }';
		wp_add_inline_style( 'easy-subscriptions-admin', $custom_css );
	}
}


	function easy_subscriptions_woocommerce_settings_tab($settings_tabs) {
		$settings_tabs['easy_subscriptions_tab'] = 'Easy Subscriptions';
		return $settings_tabs;
	}

	/**
	 * Add settings page to admin menu
	 *
	 * @return void
	 */
	public function add_menu_item() {

		// Get the main menu settings
		//$main_menu_args = $this->easy_subs_menu_settings('main');
	
		// Do nothing if wrong location key is set for the main menu.
		if (is_array($main_menu_args) && isset($main_menu_args['location']) && function_exists('add_' . $main_menu_args['location'] . '_page')) {
			switch ($main_menu_args['location']) {
				case 'menu':
					$main_page = add_menu_page(
						$main_menu_args['page_title'],
						$main_menu_args['menu_title'],
						$main_menu_args['capability'],
						$main_menu_args['menu_slug'],
						$main_menu_args['function'],
						$main_menu_args['icon_url'],
						$main_menu_args['position']
					);
					break;
				default:
					return;
			}
	
			// Enqueue assets for the main menu page
			add_action('admin_print_styles-' . $main_page, array($this, 'settings_assets'));
		}
	
	}
	


	/**
	 * Container for settings page arguments
	 *
	 * @param array $settings Settings array.
	 *
	 * @return array
	 */
	public function configure_settings( $settings = array() ) {
		return $settings;
	}

	/**
	 * Load settings JS & CSS
	 *
	 * @return void
	 */
	public function settings_assets() {

		// We're including the farbtastic script & styles here because they're needed for the colour picker
		// If you're not including a colour picker field then you can leave these calls out as well as the farbtastic dependency for the wpt-admin-js script below.
		wp_enqueue_style( 'farbtastic' );
		wp_enqueue_script( 'farbtastic' );

		// We're including the WP media scripts here because they're needed for the image upload field.
		// If you're not including an image upload then you can leave this function call out.
		wp_enqueue_media();

		wp_register_script( $this->parent->_token . '-settings-js', $this->parent->assets_url . 'js/settings' . $this->parent->script_suffix . '.js', array( 'farbtastic', 'jquery' ), '1.0.0', true );
		wp_enqueue_script( $this->parent->_token . '-settings-js' );

		
	}

	/**
	 * Add settings link to plugin list table
	 *
	 * @param  array $links Existing links.
	 * @return array        Modified links.
	 */

	public function add_settings_link( $links ) {
    	$settings_link = '<a href="admin.php?page=wc-settings&tab=easy_subscriptions_tab">' . __( 'Settings', 'easy-subscriptions' ) . '</a>';
    	array_push( $links, $settings_link );
    	return $links;
	}


	/**
	 * Register plugin settings
	 *
	 * @return void
	 */
public function register_settings() {
	if ( is_array( $this->settings ) ) {

		


		// Check posted/selected tab.
			$current_section = '';


			//phpcs:enable

			foreach ( $this->settings as $section => $data ) {

				if ( $current_section && $current_section !== $section ) {
					continue;
				}

				// Add section to page.
				add_settings_section( $section, $data['title'], array( $this, 'settings_section' ), $this->parent->_token . '_settings' );
				if (isset($data['fields']) && is_array($data['fields'])) {
				foreach ( $data['fields'] as $field ) {

					// Validation callback for field.
					$validation = '';
					if ( isset( $field['callback'] ) ) {
						$validation = $field['callback'];
					}

					// Register field.
					$option_name = $this->base . $field['id'];
					register_setting(
						$this->parent->_token . '_settings',
						$option_name,
						array(
						'sanitize_callback' => $validation
						)
					);

					// Add field to page.
					add_settings_field(
						$field['id'],
						$field['label'],
						array( $this->parent->admin, 'display_field' ),
						$this->parent->_token . '_settings',
						$section,
						array(
							'field'  => $field,
							'prefix' => $this->base,
						)
					);
				}}

				if ( ! $current_section ) {
					break;
				}
			}
		}
	}

	/**
	 * Settings section.
	 *
	 * @param array $section Array of section ids.
	 * @return void
	 */
	public function settings_section( $section ) {
		$html = '<p> ' . esc_html($this->settings[ $section['id'] ]['description']) . '</p>' . "\n";
		echo wp_kses_post($html);

	}

	/**
	 * Load settings page content.
	 *
	 * @return void
	 */
	public function easy_subscriptions_settings_page() {

		$easy_subscriptionsettings = new easy_subscriptions_settingspage();

		// Build page HTML.
		$html      = '<div class="wrap" id="' . $this->parent->_token . '_settings">' . "\n";
			$html .= '<h2>' . __( 'Easy Subscriptions', 'easy-subscriptions' ) . '</h2>' . "\n";

			$tab = '';
		//phpcs:disableif($tab != "BOGO"){
	
		//phpcs:enable
		
		// Show page tabs. if($tab != "BOGO"){
		if ( is_array( $this->settings ) && 1 < count( $this->settings ) ) {

			$html .= '<h2 class="nav-tab-wrapper">' . "\n";

			$c = 0;
			foreach ( $this->settings as $section => $data ) {

				// Set tab class.
				$class = 'nav-tab';
				if ( ! isset( $_GET['tab'] ) ) { //phpcs:ignore
					if ( 0 === $c ) {
						$class .= ' nav-tab-active';
					}
				} else {
					if ( isset( $_GET['tab'] ) && $section == $_GET['tab'] ) { //phpcs:ignore
						$class .= ' nav-tab-active';
					}
				}

				// Set tab link.
				$tab_link = add_query_arg( array( 'tab' => $section ) );
				if ( isset( $_GET['settings-updated'] ) ) { //phpcs:ignore
					$tab_link = remove_query_arg( 'settings-updated', $tab_link );
				}
				if($section != "My-Offers" && $section != "BOGO-Settings" && $section != "Excluded-Items"){
				// Output tab.
				$html .= '<a href="' . $tab_link . '" class="' . esc_attr( $class ) . '">' . esc_html( $data['title'] ) . '</a>' . "\n";
				}
				++$c;
				
			}

			$html .= '</h2>' . "\n";
		}
	

			$html .= '<form method="post" action="options.php" enctype="multipart/form-data">' . "\n";

				// Get settings fields.
				ob_start();
		

				if (empty($tab)) {
					$tab = 'Settings';
				}
				$html .= $this->easy_subscriptions_handle_tab_specific_bogo($tab, $easy_subscriptionsettings);


				$html .= ob_get_clean();

				$html     .= '<p class="submit">' . "\n";
					$html .= '<input type="hidden" name="tab" value="' . esc_attr( $tab ) . '" />' . "\n";
					
				$html     .= '</p>' . "\n";
			$html         .= '</form>' . "\n";
		$html             .= '</div>' . "\n";


		
		$default_allowed_html = wp_kses_allowed_html('post');
                                                                                                                                                                                                              
		$custom_allowed_html = array(
			'form' => array(
				'class' => array(),
				'action' => array(),
				'method' => array(),
				'autocomplete' => array(),
			),
			'div' => array(
				'class' => array(),
			),
			'h1' => array(),
			'h3' => array(),
			'table' => array(
				'class' => array(),
			),
			'tr' => array(),
			'th' => array(
				'scope' => array(),
				'colspan' => array(), // If you need colspan
			),
			'td' => array(),
			'label' => array(
				'for' => array(),
			),
			'input' => array(
				'name' => array(),
				'type' => array(),
				'id' => array(),
				'value' => array(),
				'class' => array(),
				'checked' => array(),
				'placeholder' => array(), // Add this if placeholders are used
				'style' => array(),
			),
			'select' => array(
				'name' => array(),
				'id' => array(),
				'style' => array(),
			),
			'option' => array(
				'value' => array(),
				'selected' => array(),
			),
			'span' => array(
				'id' => array(),
			),
			'p' => array(
				'class' => array(),
			),
			'button' => array(
				'type' => array(),
				'class' => array(),
				'id' => array(),
			),
			'style' => array(),
		);
		
																																																				   
                                                                                                                                                                                                              
$allowed_html = array_merge_recursive($default_allowed_html, $custom_allowed_html);
echo wp_kses($html, $allowed_html); //phpcs:ignore
//echo $html;
	}



	private function easy_subscriptions_handle_tab_specific_bogo($tab, $easy_subscriptionsettings) {
		$html = '';
	
		//switchcase to see which tab is active and opening the method in the tab as html
		switch ($tab){
			case 'Settings':
				$html .= $easy_subscriptionsettings->easy_subscriptions_display_button_text_settings();
				break;

		}
	
		return $html;
	}





	/**
	 * Main easy_subscriptions_Settings Instance
	 *
	 * Ensures only one instance of easy_subscriptions_Settings is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @see easy_subscriptions()
	 * @param object $parent Object instance.
	 * @return object easy_subscriptions_Settings instance
	 */
	public static function instance( $parent ) {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self( $parent );
		}
		return self::$_instance;
	} // End instance()



}
