<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'admin_enqueue_scripts', 'easy_subscriptions_enqueue_wc_scripts' );
add_action( 'admin_enqueue_scripts', 'easy_subscriptions_enqueue_admin_scripts' );
add_action( 'woocommerce_thankyou', 'easy_subscriptions_enqueue_thankyou_script', 30 );
add_action( 'wp_enqueue_scripts', 'easy_subscriptions_hide_paypal_buttons', 20 );
add_action( 'wp_enqueue_scripts', 'easy_subscriptions_enqueue_paypal_express_button_script' );


//script to hide and show the fields in the product subs settings on toggle
function easy_subscriptions_enqueue_wc_scripts( $hook ) {
    // Load script only on WooCommerce product edit screens
    if ( 'post.php' !== $hook && 'post-new.php' !== $hook ) {
        return;
    }

    $screen = get_current_screen();
    if ( empty( $screen ) || 'product' !== $screen->post_type ) {
        return;
    }

    wp_enqueue_script(
        'easy-subscriptions-wc-data-settings',
        plugins_url( 'assets/js/easy-subscriptions-wc-data-settings.js', dirname( __FILE__, 2 ) ), // adjust path
        array( 'jquery' ),
        '1.0.0',
        true
    );
}


//script to hide and show the subs tab
function easy_subscriptions_enqueue_admin_scripts( $hook ) {
    if ( ! function_exists( 'get_current_screen' ) ) {
        return;
    }

    $screen = get_current_screen();
    if ( ! $screen || 'product' !== $screen->id ) {
        return;
    }

    // Enqueue your JS file
    wp_enqueue_script(
        'easy-subscriptions-admin-footer',
        plugin_dir_url( __FILE__ ) . '../../assets/js/easy-subscriptions-admin-footer.js',
        array( 'jquery' ), // dependencies
        '1.0.0',
        true // load in footer
    );

    // Optionally enqueue the small CSS snippet too
    wp_add_inline_style(
        'woocommerce_admin_styles', // or another handle already used in admin
        '.show_if_easy_subscriptions{display:none}'
    );
}



//approval link for subscriptions on paypal
function easy_subscriptions_enqueue_thankyou_script( $order_id ) {
    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return;
    }

    if ( $order->get_payment_method() === 'ppcp-gateway' ) {
        $approve_url = get_post_meta( $order_id, '_paypal_subscription_approve_url', true );

        if ( $approve_url ) {
            // Enqueue external JS file
            wp_enqueue_script(
                'easy-subscriptions-thank-you-wait',
                plugin_dir_url( __FILE__ ) . '../../assets/js/easy-subscriptions-thank-you-wait.js',
                array(),
                '1.0.0',
                true
            );

            // Pass the approval URL to the script
            wp_localize_script(
                'easy-subscriptions-thank-you-wait',
                'easySubscriptionsThankYou',
                array(
                    'approveUrl' => esc_url( $approve_url ),
                    'message'    => __( 'Please wait, redirecting you to PayPal to approve your subscription...', 'easy-subscriptions' ),
                )
            );

            // Output the message on the thank-you page
            echo '<p>' . esc_html__( 'Please wait, redirecting you to PayPal to approve your subscription...', 'easy-subscriptions' ) . '</p>';
        }
    }
}




function easy_subscriptions_hide_paypal_buttons() {
    if ( ! function_exists( 'WC' ) || ! WC()->cart ) {
        return;
    }

    if (
        ( is_cart() && WC()->cart->get_cart_contents_count() > 1 ) ||
        ( is_checkout() && ! is_wc_endpoint_url() && function_exists( 'easy_subscriptions_count_in_cart' ) && easy_subscriptions_count_in_cart() > 1 )
    ) {
        // Register "empty" stylesheet with a version so linters are happy
        wp_register_style( 'easy-subscriptions-inline', false, array(), '1.0.0' );
        wp_enqueue_style( 'easy-subscriptions-inline' );

        wp_add_inline_style(
            'easy-subscriptions-inline',
            '.wcppec-checkout-buttons,
             .paypal-buttons,
             .ppcp-button,
             .ppc-button-wrapper,
             .wc-ppcp-paypal-button-container,
             [class*="paypal"],
             [class*="ppcp"] {
                 display: none !important;
             }'
        );
    }
}

//Remove PayPal express buttons from cart & product pages (only if qty ≥ 2)
function easy_subscriptions_enqueue_paypal_express_button_script() {
    // 🔹 Cart page: hide buttons via CSS if cart has multiple items
    // 🔹 Product page: hide/show via JS if quantity selector ≥ 2
    if ( is_product() ) {
        wp_enqueue_script(
            'easy-subscriptions-paypal-express-button',
            plugin_dir_url( __FILE__ ) . '../../assets/js/easy-subscriptions-paypal-express-button.js',
            array( 'jquery' ),
            '1.0.0',
            true
        );
    }
}