<?php
if ( ! defined( 'ABSPATH' ) ) exit;

//woocommerce css for active style
add_action( 'admin_enqueue_scripts', function( $hook ) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
    if ( isset($_GET['page']) && $_GET['page'] === 'easy-subscriptions' ) {
        wp_enqueue_style( 'woocommerce_admin_styles' );
    }
});

add_action( 'admin_head', function() {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
    if ( isset($_GET['page']) && $_GET['page'] === 'easy-subscriptions' ) : ?>
        <style>
        .order-status {
            padding: 0.2em 0.6em !important; /* add left and right padding */
            display: inline-block;
        }
        </style>
    <?php endif;
});


class Easy_Subscriptions_Admin_Page {

    
    public static function init() {
        add_action( 'admin_menu', [ __CLASS__, 'register_page' ] );
    }

    public static function register_page() {
        add_submenu_page(
            'woocommerce',
            __( 'Easy Subscriptions', 'easy-subscriptions' ),
            __( 'Easy Subscriptions', 'easy-subscriptions' ),
            'manage_woocommerce',
            'easy-subscriptions',
            [ __CLASS__, 'render_page' ]
        );
    }

public static function render_page() {
    $per_page = 20;
    if ( isset( $_GET['_easy_subs_nonce'] ) 
        && wp_verify_nonce( sanitize_key( $_GET['_easy_subs_nonce'] ), 'easy_subscriptions_list' ) ) {
        $paged  = isset( $_GET['paged'] ) ? max( 1, absint( $_GET['paged'] ) ) : 1;
        $search = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';
    } else {
        $paged  = 1;
        $search = '';
    }

    $args = [
        'type'     => [ 'shop_order', 'shop_order_placehold' ],
        'orderby'  => 'date',
        'order'    => 'DESC',
        'limit'    => $per_page,
        'paged'    => $paged,
        'paginate' => true,
        'meta_query' => [
        [
            'key'     => '_easy_subscriptions_scheduled',
            'value'   => 'yes',
            'compare' => '=',
        ],
        ],
    ];

    // 🔍 Search logic
    if ( $search ) {
        if ( is_numeric( $search ) ) {
            $args['id'] = absint( $search );
        } else {
            $args['search'] = '*' . $search . '*';
        }
    }

    $result = wc_get_orders( $args );
    $orders = $result->orders ?? (array) $result;

    // Post-filter by item name if not numeric
    if ( $search && ! is_numeric( $search ) ) {
        $orders = array_filter( $orders, function( $order ) use ( $search ) {
            foreach ( $order->get_items() as $item ) {
                if ( stripos( $item->get_name(), $search ) !== false ) {
                    return true;
                }
            }
            return false;
        } );
    }

    $total         = $result->total ?? count( $orders );
    $max_num_pages = $result->max_num_pages ?? 1;

    $template_base = trailingslashit( dirname( __FILE__, 2 ) ) . 'templates/';
    wc_get_template(
        'easy-subscriptions-admin-tab.php',
        [
            'orders'        => $orders,
            'paged'         => $paged,
            'per_page'      => $per_page,
            'total'         => $total,
            'max_num_pages' => $max_num_pages,
        ],
        '',
        $template_base
    );
}
}

Easy_Subscriptions_Admin_Page::init();