<?php
/**
 * Settings class file.
 *
 * @package Easy Subscriptions/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
add_filter('woocommerce_product_single_add_to_cart_text', 'easy_subscriptions_add_to_cart_button_text', 10, 2);

class easy_subscriptions_settingspage {

	function easy_subscriptions_display_button_text_settings() {

		// Save plugin settings
		if ( isset( $_POST['easy_subscriptions_save_settings'] ) ) {

			// Verify nonce
			if ( ! isset( $_POST['easy_subscriptions_settings_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['easy_subscriptions_settings_nonce'] ), 'easy_subscriptions_save_settings_action' ) ) {
				wp_die( 'Security check failed. Please try again.' );
			}

			// Save fields
			update_option( 'easy_subscriptions_add_to_cart_button_text', sanitize_text_field( wp_unslash( $_POST['easy_subscriptions_add_to_cart_button_text'] ?? '' ) ));
			update_option( 'easy_subscriptions_place_order_button_text', sanitize_text_field( wp_unslash( $_POST['easy_subscriptions_place_order_button_text'] ?? '' ) ));

			// Checkbox
			$retry_failed_payments = isset( $_POST['easy_subscriptions_retry_failed_payments'] ) ? true : false;
			update_option( 'easy_subscriptions_retry_failed_payments', $retry_failed_payments );

			update_option( 'easy_subscriptions_payment_grace_hours', absint( $_POST['easy_subscriptions_payment_grace_hours'] ?? 48 ) );
			update_option( 'easy_subscriptions_payment_status_action', sanitize_text_field( wp_unslash( $_POST['easy_subscriptions_payment_status_action'] ?? 'suspended' ) ));
			update_option( 'easy_subscriptions_payment_grace_days', absint( $_POST['easy_subscriptions_payment_grace_days'] ?? 20 ) );

			// Cancel limits
			update_option( 'easy_subscriptions_time_after_creation', absint( $_POST['easy_subscriptions_time_after_creation'] ?? 0 ) );
			update_option( 'easy_subscriptions_time_before_renew', absint( $_POST['easy_subscriptions_time_before_renew'] ?? 0 ) );

			echo '<div class="updated"><p>Settings saved successfully!</p></div>';
		}

		$this->easy_subscriptions_getpremium();

		wp_nonce_field( 'easy_subscriptions_save_settings_action', 'easy_subscriptions_settings_nonce' );
		echo '</table><p class="submit">
				<input type="submit" name="easy_subscriptions_save_settings" id="submit" class="button button-primary" value="Save Settings">
			</p>
		';
	}

	function easy_subscriptions_getpremium() {

		// Get values
		$add_to_cart_button_text   = get_option( 'easy_subscriptions_add_to_cart_button_text', '' );
		$retry_failed_payments     = get_option( 'easy_subscriptions_retry_failed_payments', false );
		$payment_grace_hours       = get_option( 'easy_subscriptions_payment_grace_hours', 48 );
		$payment_status_action     = get_option( 'easy_subscriptions_payment_status_action', 'suspended' );
		$payment_grace_days        = get_option( 'easy_subscriptions_payment_grace_days', 20 );
		$time_after_creation       = get_option( 'easy_subscriptions_time_after_creation', 0 );
		$time_before_renew         = get_option( 'easy_subscriptions_time_before_renew', 0 );

		echo '<div class="wrap woocommerce easy-subscriptions-settings">
				<table class="form-table">';

		// Button text section
		echo '
			<tr>
				<th colspan="2"><h2>' . esc_html( 'General Settings' ) . '</h2></th>
			</tr>
			<tr>
				<th scope="row"><label for="easy_subscriptions_add_to_cart_button_text">' . esc_html( 'Add to cart button text' ) . '</label></th>
				<td><input name="easy_subscriptions_add_to_cart_button_text" type="text" id="easy_subscriptions_add_to_cart_button_text" placeholder="' . esc_attr__( 'subscribe', 'easy-subscriptions' ) . '" value="' . esc_attr( $add_to_cart_button_text ) . '" class="regular-text" /></td>
			</tr>
			<tr>
				<th scope="row"><label for="easy_subscriptions_retry_failed_payments">' . esc_html( 'Retry failed payments' ) . '</label></th>
				<td>
					<label>
						<input type="checkbox" name="easy_subscriptions_retry_failed_payments" ' . checked( (bool) $retry_failed_payments, true, false ) . ' />
						' . esc_html( 'Enable retry for failed payments' ) . '
					</label>
				</td>
			</tr>';

		echo '
			<tr>
				<th colspan="2"><h2>' . esc_html( 'Unpaid Payment Handling' ) . '</h2></th>
			</tr>
			<tr>
				<th scope="row"><label for="easy_subscriptions_payment_grace_hours">' . esc_html( 'Unpaid payment handling' ) . '</label></th>
				<td>
					' . esc_html__( 'If a payment is not paid after', 'easy-subscriptions' ) . ' <input name="easy_subscriptions_payment_grace_hours" type="number" id="easy_subscriptions_payment_grace_hours" value="' . esc_attr( $payment_grace_hours ) . '" style="width:60px;" /> ' . esc_html__( 'hours,', 'easy-subscriptions' ) . '
					' . esc_html__( 'set the subscription status to', 'easy-subscriptions' ) . '
					<select name="easy_subscriptions_payment_status_action" id="easy_subscriptions_payment_status_action" style="width:200px;">';
		?>
					<option value="suspended" <?php selected( esc_attr( $payment_status_action ), 'suspended' ); ?>><?php echo esc_html( 'Suspended' ); ?></option>
					<option value="cancelled" <?php selected( esc_attr( $payment_status_action ), 'cancelled' ); ?>><?php echo esc_html( 'Cancelled' ); ?></option>
		<?php
		echo '</select>
					' . esc_html__( 'for', 'easy-subscriptions' ) . ' <input name="easy_subscriptions_payment_grace_days" type="number" id="easy_subscriptions_payment_grace_days" value="' . esc_attr( $payment_grace_days ) . '" style="width:60px;" /> ' . esc_html__( 'days before cancelling it.', 'easy-subscriptions' ) . '
				</td>
			</tr>';

		// Cancel limits section
		echo '
			<tr>
				<th colspan="2"><h2>' . esc_html( 'Cancel Limits' ) . '</h2></th>
			</tr>
			<tr>
				<th scope="row"><label for="easy_subscriptions_time_after_creation">' . esc_html( 'Time after creation in days' ) . '</label></th>
				<td><input name="easy_subscriptions_time_after_creation" type="number" id="easy_subscriptions_time_after_creation" value="' . esc_attr( $time_after_creation ) . '" style="width:60px;" /></td>
			</tr>
			<tr>
				<th scope="row"><label for="easy_subscriptions_time_before_renew">' . esc_html( 'Time before renew date in days' ) . '</label></th>
				<td><input name="easy_subscriptions_time_before_renew" type="number" id="easy_subscriptions_time_before_renew" value="' . esc_attr( $time_before_renew ) . '" style="width:60px;" /></td>
			</tr>';
	}

	
}

function easy_subscriptions_add_to_cart_button_text($button_text, $product) {
    global $post;
    $easy_subscriptions_message = '';
    // 1. Check if the easy-subs is enabled for this product
    $easy_subscriptions_enabled = get_post_meta($product->get_id(), '_easy_subscriptions', true);

    $easy_subscriptions_custom_easy_subscriptions_button_text = get_post_meta($post->ID, 'easy_subscriptions_add_to_cart_button_text', true);
    $easy_subscriptions_additional_info_text = get_option('easy_subscriptions_add_to_cart_button_text', 'Subscribe');

    // If pre-order is enabled, use the determined message, otherwise return the default Add to Cart text
    if ($easy_subscriptions_enabled === 'yes') {
        if (!empty($easy_subscriptions_additional_info_text)) {
            return $easy_subscriptions_additional_info_text;
        } else {
            return $button_text; // fallback to default Add to Cart text
        }
    }
    // Return default Add to Cart text if pre-order is not enabled
    return $button_text;
}
