jQuery(function ($) {
  // Only relevant if Stripe.js is present
  if (typeof Stripe === "undefined" || !window.easy_subs_params || !easy_subs_params.publishableKey) {
    return;
  }

  var stripe = Stripe(easy_subs_params.publishableKey);
  var elements = stripe.elements();
  var cardElement = null;

  // Prevent double-submission loops
  var submittingWithPM = false;

  function ensureHiddenField() {
    if ($("#easy_subscriptions_payment_method_id").length === 0) {
      // Put it inside the checkout form (classic checkout)
      var $form = $("form.checkout");
      if ($form.length) {
        $form.append('<input type="hidden" id="easy_subscriptions_payment_method_id" name="easy_subscriptions_payment_method_id" value="">');
      }
    }
  }

  function mountCard() {
    var $mount = $("#easy_subscriptions_card_element");

    // If the element isn't in the DOM yet, nothing to mount
    if (!$mount.length) return;

    // If we already mounted, do nothing
    if (cardElement) return;

    cardElement = elements.create("card");
    cardElement.mount("#easy_subscriptions_card_element");
  }

  // Try mounting immediately
  ensureHiddenField();
  mountCard();

  // Re-try after WooCommerce refreshes checkout fragments (classic checkout)
  $(document.body).on("updated_checkout init_checkout wc_fragments_loaded", function () {
    ensureHiddenField();
    mountCard();
  });

  // Also watch for late-rendered markup (some themes/shortcodes do this)
  var obs = new MutationObserver(function () {
    if (!cardElement && $("#easy_subscriptions_card_element").length) {
      ensureHiddenField();
      mountCard();
    }
  });
  obs.observe(document.body, { childList: true, subtree: true });

  /**
   * CLASSIC (shortcode) checkout fix:
   * Intercept the actual form submit (sync), do async Stripe call, then resubmit once.
   */
  $(document).on("submit", "form.checkout", function (e) {
    // If the card UI isn't even present, don't interfere.
    // (This also helps not to break Blocks or other flows.)
    if (!$("#easy_subscriptions_card_element").length) {
      return true;
    }

    // If we're resubmitting after having created the PM, let it pass.
    if (submittingWithPM) {
      return true;
    }

    // If card isn't ready, block submission
    if (!cardElement) {
      e.preventDefault();
      window.alert("Payment form is not ready yet. Please try again.");
      return false;
    }

    // If we already have a PM id, let it submit
    var existing = $("#easy_subscriptions_payment_method_id").val();
    if (existing) {
      return true;
    }

    // Stop the normal submit, do Stripe async work
    e.preventDefault();

    // Optional: trigger WooCommerce block UI (spinner)
    $(document.body).trigger("checkout_error"); // harmless if not used by theme

    stripe
      .createPaymentMethod({
        type: "card",
        card: cardElement,
        billing_details: {
          email: $("#billing_email").val() || undefined,
          name: ($("#billing_first_name").val() || "") + " " + ($("#billing_last_name").val() || ""),
          phone: $("#billing_phone").val() || undefined,
        },
      })
      .then(function (result) {
        if (result.error) {
          window.alert(result.error.message);
          return;
        }

        $("#easy_subscriptions_payment_method_id").val(result.paymentMethod.id);

        // Resubmit once, without looping back into Stripe again
        submittingWithPM = true;

        // WooCommerce uses either a normal submit or a place order click depending on setup;
        // safest is to submit the form directly.
        e.target.submit();
      });

    return false;
  });
});