<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter( 'woocommerce_product_data_tabs', 'bogo_for_woocommerce_add_product_data_tab_woo' );
function bogo_for_woocommerce_add_product_data_tab_woo( $tabs ) {
    $tabs['bogo'] = array(
        'label'  => __( 'BOGO', 'bogo_for_woocommerce' ),
        'target' => 'bogo_for_woocommerce_ps_setup',
        'class'  => array(),
    );
    return $tabs;
}

// Add custom fields
add_action( 'woocommerce_product_data_panels', 'bogo_for_woocommerce_main_settings' );
function bogo_for_woocommerce_main_settings() {
    global $post;

    $bogo_enabled = get_post_meta( $post->ID, '_bogo_for_woocommerce_enabled', true );
    $offer_type   = get_post_meta( $post->ID, '_bogo_for_woocommerce_offer_type', true );
    $discount     = get_post_meta( $post->ID, '_bogo_for_woocommerce_discount', true );
    $selected_products = get_post_meta( $post->ID, '_bogo_for_woocommerce_selected_products', true );
    $quantity_to_buy      = get_post_meta( $post->ID, '_bogo_for_woocommerce_quantity_to_buy', true );
    $quantity_to_sell     = get_post_meta( $post->ID, '_bogo_for_woocommerce_quantity_to_sell', true );
    $max_free_qty         = get_post_meta( $post->ID, '_bogo_for_woocommerce_max_free_qty', true );
    $shop_message         = get_post_meta( $post->ID, '_bogo_for_woocommerce_shop_message', true );
    $discount_amount      = get_post_meta( $post->ID, '_bogo_for_woocommerce_discount_amount', true );
    $currency_symbol = get_woocommerce_currency_symbol();


    wp_nonce_field( 'bogo_for_woocommerce_save_data', 'bogo_for_woocommerce_nonce' );
    ?>
    <div id="bogo_for_woocommerce_ps_setup" class="panel woocommerce_options_panel">
        <div class="options_group">
            <p class="form-field">
                <label for="bogo_for_woocommerce_enabled"><?php _e( 'Enable BOGO for this product', 'bogo_for_woocommerce' ); ?></label>
                <input type="checkbox" name="bogo_for_woocommerce_enabled" id="bogo_for_woocommerce_enabled" value="yes" <?php checked( $bogo_enabled, 'yes' ); ?> />
            </p>

            <p class="form-field">
                <label for="bogo_for_woocommerce_offer_type"><?php _e( 'Offer Type', 'bogo_for_woocommerce' ); ?></label>
                <select name="bogo_for_woocommerce_offer_type" id="bogo_for_woocommerce_offer_type">
                    <option value="1" <?php selected( $offer_type, '1' ); ?>>Buy A Get A Free</option>
                    <option value="2" <?php selected( $offer_type, '2' ); ?>>Buy A Get B Free (Premium)</option>
                </select>
            </p>

<p class="form-field">
    <label for="bogo_for_woocommerce_selected_products"><?php _e( 'Select products', 'bogo_for_woocommerce' ); ?></label>
    <select 
        name="bogo_for_woocommerce_selected_products[]" 
        id="bogo_for_woocommerce_selected_products" 
        multiple="multiple" 
        style="width: 100%;">
        <?php
        $products = wc_get_products( array( 'limit' => -1 ) );
        foreach ( $products as $product ) {
            $selected = is_array($selected_products) && in_array( $product->get_id(), $selected_products ) ? 'selected' : '';
            echo '<option value="' . esc_attr( $product->get_id() ) . '" ' . $selected . '>' . esc_html( $product->get_name() ) . '</option>';
        }
        ?>
    </select>
</p>



            <p class="form-field">
                <label for="bogo_for_woocommerce_discount"><?php _e( 'Discount Type', 'bogo_for_woocommerce' ); ?></label>
                <select name="bogo_for_woocommerce_discount" id="bogo_for_woocommerce_discount">
                    <option value="free" <?php selected( $discount, 'free' ); ?>>Free</option>
                    <option value="percentage" <?php selected( $discount, 'percentage' ); ?>>Percentage Discount (Premium)</option>
                    <option value="flat" <?php selected( $discount, 'flat' ); ?>>Flat Discount (Premium)</option>
                    <option value="flat_price" <?php selected( $discount, 'flat_price' ); ?>>Flat Price (Premium)</option>
                </select>
            </p>

                        <!-- Discount Amount (shown conditionally) -->
            <p class="form-field" id="bogo_discount_amount_wrapper">
                <label for="bogo_for_woocommerce_discount_amount"><?php _e( 'Discount Amount', 'bogo_for_woocommerce' ); ?></label>
                <input type="number" step="0.01" name="bogo_for_woocommerce_discount_amount" value="<?php echo esc_attr( $discount_amount ); ?>" style="width: 80px;" />
                <span id="discount_symbol"></span>
            </p>


            <!-- Quantity to Buy -->
            <p class="form-field">
                <label for="bogo_for_woocommerce_quantity_to_buy"><?php _e( 'Quantity to Buy', 'bogo_for_woocommerce' ); ?></label>
                <input type="number" min="1" name="bogo_for_woocommerce_quantity_to_buy" value="<?php echo esc_attr( $quantity_to_buy ); ?>" />
            </p>

            <!-- Quantity to Sell -->
            <p class="form-field">
                <label for="bogo_for_woocommerce_quantity_to_sell"><?php _e( 'Quantity to Sell (Free or Discounted)', 'bogo_for_woocommerce' ); ?></label>
                <input type="number" min="1" name="bogo_for_woocommerce_quantity_to_sell" value="<?php echo esc_attr( $quantity_to_sell ); ?>" />
            </p>

            <!-- Max Free Quantity -->
            <p class="form-field">
                <label for="bogo_for_woocommerce_max_free_qty"><?php _e( 'Maximum Free Quantity', 'bogo_for_woocommerce' ); ?></label>
                <input type="number" min="1" name="bogo_for_woocommerce_max_free_qty" value="<?php echo esc_attr( $max_free_qty ); ?>" />
            </p>

            <!-- Message Shown in Shop -->
            <p class="form-field">
                <label for="bogo_for_woocommerce_shop_message"><?php _e( 'Message Shown in Shop (Premium)', 'bogo_for_woocommerce' ); ?></label>
                <input type="text" name="bogo_for_woocommerce_shop_message" value="<?php echo esc_attr( $shop_message ); ?>" placeholder="<?php _e('e.g. Buy {buy_qty} get {sell_qty} free of {free_item}', 'bogo_for_woocommerce'); ?>" />
                <small><?php _e( 'You can use shortcodes: {buy_qty}, {sell_qty}, {max_free_qty}, {buy_item}, {free_item}', 'bogo_for_woocommerce' ); ?></small>
            </p>



        </div>
    </div>
<script>
jQuery(document).ready(function($) {
    function toggleProductSelector() {
        if ($('#bogo_for_woocommerce_offer_type').val() == '2') {
            $('#bogo_product_selector').show();
        } else {
            $('#bogo_product_selector').hide();
        }
    }

    $('#bogo_for_woocommerce_offer_type').change(toggleProductSelector);
    toggleProductSelector();

    $('#bogo_for_woocommerce_selected_products').select2({
        width: '100%',
        placeholder: 'Select products',
        allowClear: true
    });
});
</script>

<script>
    jQuery(document).ready(function($) {
        function toggleDiscountAmount() {
            var discountType = $('#bogo_for_woocommerce_discount').val();
            var symbol = (discountType === 'percentage') ? '%' : '<?php echo html_entity_decode( $currency_symbol ); ?>';
            if (discountType === 'free') {
                $('#bogo_discount_amount_wrapper').hide();
            } else {
                $('#bogo_discount_amount_wrapper').show();
                $('#discount_symbol').text(symbol);
            }
        }

        $('#bogo_for_woocommerce_discount').change(toggleDiscountAmount);
        toggleDiscountAmount();
    });
    </script>


    <?php
}

// Save fields
add_action( 'woocommerce_process_product_meta', 'bogo_for_woocommerce_save_product_settings' );
function bogo_for_woocommerce_save_product_settings( $post_id ) {
    if ( ! isset( $_POST['bogo_for_woocommerce_nonce'] ) || ! wp_verify_nonce( $_POST['bogo_for_woocommerce_nonce'], 'bogo_for_woocommerce_save_data' ) ) {
        return;
    }

    update_post_meta( $post_id, '_bogo_for_woocommerce_enabled', isset( $_POST['bogo_for_woocommerce_enabled'] ) ? 'yes' : 'no' );
    update_post_meta( $post_id, '_bogo_for_woocommerce_offer_type', sanitize_text_field( $_POST['bogo_for_woocommerce_offer_type'] ) );
    update_post_meta( $post_id, '_bogo_for_woocommerce_discount', sanitize_text_field( $_POST['bogo_for_woocommerce_discount'] ) );
    update_post_meta( $post_id, '_bogo_for_woocommerce_quantity_to_buy', intval( $_POST['bogo_for_woocommerce_quantity_to_buy'] ) );
    update_post_meta( $post_id, '_bogo_for_woocommerce_quantity_to_sell', intval( $_POST['bogo_for_woocommerce_quantity_to_sell'] ) );
    update_post_meta( $post_id, '_bogo_for_woocommerce_max_free_qty', intval( $_POST['bogo_for_woocommerce_max_free_qty'] ) );
    update_post_meta( $post_id, '_bogo_for_woocommerce_shop_message', sanitize_text_field( $_POST['bogo_for_woocommerce_shop_message'] ) );

    if ($_POST['bogo_for_woocommerce_discount'] !== 'free') {
        update_post_meta( $post_id, '_bogo_for_woocommerce_discount_amount', floatval( $_POST['bogo_for_woocommerce_discount_amount'] ) );
    } else {
        delete_post_meta( $post_id, '_bogo_for_woocommerce_discount_amount' );
    }

    if ( $_POST['bogo_for_woocommerce_offer_type'] === '2' ) {
        $selected_products = isset( $_POST['bogo_for_woocommerce_selected_products'] ) ? array_map( 'intval', $_POST['bogo_for_woocommerce_selected_products'] ) : array();
        update_post_meta( $post_id, '_bogo_for_woocommerce_selected_products', $selected_products );
    } else {
        delete_post_meta( $post_id, '_bogo_for_woocommerce_selected_products' );
    }
}


$bogo_for_woocommerce_activation_key = get_option('check_if_bogo_for_woocommerce_active');
if ($bogo_for_woocommerce_activation_key) {
add_action( 'woocommerce_before_calculate_totals', 'bogo_for_woocommerce_handle_cart_offers', 20 );
}

function bogo_for_woocommerce_handle_cart_offers( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) ) return;
    if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 ) return;

    // First pass: Remove all existing BOGO items
    foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
        if ( isset( $cart_item['bogo_added'] ) ) {
            $cart->remove_cart_item( $cart_item_key );
        }
    }

    // Second pass: Apply new BOGO offers
    $bogo_processed = array();
    foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
        $product_id = $cart_item['product_id'];
        
        // Skip if already processed or not BOGO enabled
        if ( in_array( $product_id, $bogo_processed ) || 
             get_post_meta( $product_id, '_bogo_for_woocommerce_enabled', true ) !== 'yes' ) {
            continue;
        }
        
        $bogo_processed[] = $product_id;
        $quantity = $cart_item['quantity'];
        $offer_type = get_post_meta( $product_id, '_bogo_for_woocommerce_offer_type', true );
        $qty_buy = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_quantity_to_buy', true );
        $qty_sell = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_quantity_to_sell', true );
        $max_free = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_max_free_qty', true );
        $discount_type = get_post_meta( $product_id, '_bogo_for_woocommerce_discount', true );
        $discount_value = get_post_meta( $product_id, '_bogo_for_woocommerce_discount_amount', true );
        
        // Calculate eligible sets
        $bogo_sets = floor( $quantity / $qty_buy );
        if ( $bogo_sets < 1 ) continue;
        
        $free_qty = $bogo_sets * $qty_sell;
        if ( $max_free && $free_qty > $max_free ) {
            $free_qty = $max_free;
        }
        
        // Get free products
        $free_product_ids = array();
        if ( $offer_type === '1' ) {
            $free_product_ids[] = $product_id;
        }
        
        // Add BOGO items with fixed quantity
        foreach ( $free_product_ids as $free_id ) {
            $price_override = false;
            $free_product = wc_get_product( $free_id );
            
            if ( $discount_type === 'free' ) {
                $price_override = 0;
            } 
            
            // Add to cart with fixed quantity
            $cart->add_to_cart( 
                $free_id, 
                $free_qty, // Fixed quantity from settings
                0, 
                array(), 
                array(
                    'bogo_added' => true,
                    'bogo_origin' => $product_id,
                    'bogo_price_override' => $price_override,
                    'bogo_fixed_qty' => $free_qty // Store intended quantity
                )
            );
        }
    }
}

// Set prices for BOGO items
add_action( 'woocommerce_before_calculate_totals', 'bogo_for_woocommerce_set_prices', 30 );
function bogo_for_woocommerce_set_prices( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) ) return;
    
    foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
        if ( isset( $cart_item['bogo_price_override'] ) ) {
            $cart_item['data']->set_price( $cart_item['bogo_price_override'] );
        }
    }
}

// Enforce fixed quantity for BOGO items
add_filter( 'woocommerce_cart_item_quantity', 'bogo_for_woocommerce_lock_quantity', 10, 3 );
function bogo_for_woocommerce_lock_quantity( $input_html, $cart_item_key, $cart_item ) {
    if ( isset( $cart_item['bogo_fixed_qty'] ) ) {
        return '<span class="bogo-qty">' . $cart_item['quantity'] . '</span>';
    }
    return $input_html;
}

add_filter('woocommerce_cart_item_removed', 'remove_bogo_free_items_when_origin_removed', 10, 2);
function remove_bogo_free_items_when_origin_removed($cart_item_key, $cart) {
    $removed_item = $cart->removed_cart_contents[ $cart_item_key ];

    if (!isset($removed_item['product_id'])) return;

    $removed_product_id = $removed_item['product_id'];

    // Loop through remaining cart and remove associated BOGO items
    foreach ($cart->get_cart() as $key => $item) {
        if (isset($item['bogo_added']) && $item['bogo_added'] && isset($item['bogo_origin']) && $item['bogo_origin'] == $removed_product_id) {
            $cart->remove_cart_item($key);
        }
    }
}