<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('woocommerce_single_product_summary', 'bogo_for_woocommerce_shop_message', 25);
function  bogo_for_woocommerce_shop_message() {
    global $product;

    if ( get_post_meta( $product->get_id(), '_bogo_for_woocommerce_enabled', true ) !== 'yes' ) return;

    $msg = get_post_meta( $product->get_id(), '_bogo_for_woocommerce_shop_message', true );
    $qty_buy = get_post_meta( $product->get_id(), '_bogo_for_woocommerce_quantity_to_buy', true );
    $qty_sell = get_post_meta( $product->get_id(), '_bogo_for_woocommerce_quantity_to_sell', true );
    $max_qty = get_post_meta( $product->get_id(), '_bogo_for_woocommerce_max_free_qty', true );
    $buy_name = $product->get_name();
    $free_name = $product->get_name();

    if ( get_post_meta( $product->get_id(), '_bogo_for_woocommerce_offer_type', true ) === '2' ) {
        $selected_ids = get_post_meta( $product->get_id(), '_bogo_for_woocommerce_selected_products', true );
        if ( is_array( $selected_ids ) && ! empty( $selected_ids ) ) {
            $names = array();
            foreach ( $selected_ids as $id ) {
                $p = wc_get_product( $id );
                if ( $p ) {
                    $names[] = $p->get_name();
                }
            }
            $free_name = implode( ', ', $names );
        }
    }


    $replacements = array(
        '{buy_qty}' => $qty_buy,
        '{sell_qty}' => $qty_sell,
        '{max_free_qty}' => $max_qty,
        '{buy_item}' => $buy_name,
        '{free_item}' => $free_name,
    );

    if($msg != null){
        echo '<div class="woocommerce-message bogo-message">' . strtr( $msg, $replacements ) . '</div>';
    }
}


add_action( 'woocommerce_before_calculate_totals', 'abogo_for_woocommerce_handle_cart_offers', 20 );
function abogo_for_woocommerce_handle_cart_offers( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) ) return;
    if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 ) return;

    // First pass: Remove all existing BOGO items
    foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
        if ( isset( $cart_item['bogo_added'] ) ) {
            $cart->remove_cart_item( $cart_item_key );
        }
    }

    // Second pass: Apply new BOGO offers
    $bogo_processed = array();
    foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
        $product_id = $cart_item['product_id'];
        
        // Skip if already processed or not BOGO enabled
        if ( in_array( $product_id, $bogo_processed ) || 
             get_post_meta( $product_id, '_bogo_for_woocommerce_enabled', true ) !== 'yes' ) {
            continue;
        }
        
        $bogo_processed[] = $product_id;
        $quantity = $cart_item['quantity'];
        $offer_type = get_post_meta( $product_id, '_bogo_for_woocommerce_offer_type', true );
        $qty_buy = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_quantity_to_buy', true );
        $qty_sell = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_quantity_to_sell', true );
        $max_free = (int) get_post_meta( $product_id, '_bogo_for_woocommerce_max_free_qty', true );
        $discount_type = get_post_meta( $product_id, '_bogo_for_woocommerce_discount', true );
        $discount_value = get_post_meta( $product_id, '_bogo_for_woocommerce_discount_amount', true );
        
        // Calculate eligible sets
        $bogo_sets = floor( $quantity / $qty_buy );
        if ( $bogo_sets < 1 ) continue;
        
        $free_qty = $bogo_sets * $qty_sell;
        if ( $max_free && $free_qty > $max_free ) {
            $free_qty = $max_free;
        }
        
        // Get free products
        $free_product_ids = array();
        if ( $offer_type === '1' ) {
            $free_product_ids[] = $product_id;
        } elseif ( $offer_type === '2' ) {
            $selected = get_post_meta( $product_id, '_bogo_for_woocommerce_selected_products', true );
            if ( is_array( $selected ) ) $free_product_ids = $selected;
        }
        
        // Add BOGO items with fixed quantity
        foreach ( $free_product_ids as $free_id ) {
            $price_override = false;
            $free_product = wc_get_product( $free_id );
            
            if ( $discount_type === 'free' ) {
                $price_override = 0;
            } elseif ( $discount_type === 'percentage' ) {
                $price_override = $free_product->get_price() * ( ( 100 - $discount_value ) / 100 );
            } elseif ( $discount_type === 'flat' ) {
                $price_override = max( 0, $free_product->get_price() - $discount_value );
            } elseif ( $discount_type === 'flat_price' ) {
                $price_override = $discount_value;
            }
            
            // Add to cart with fixed quantity
            $cart->add_to_cart( 
                $free_id, 
                $free_qty, // Fixed quantity from settings
                0, 
                array(), 
                array(
                    'bogo_added' => true,
                    'bogo_origin' => $product_id,
                    'bogo_price_override' => $price_override,
                    'bogo_fixed_qty' => $free_qty // Store intended quantity
                )
            );
        }
    }
}
