<?php
/**
 * Settings class file.
 *
 * @package WordPress Plugin Template/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * displays all orders in the admin settings.
 */
class bogo_for_woocommerce_settingspage{


	function bogo_for_woocommerce_display_button_text_settings() {
    // Check if the form was submitted

    if (isset($_POST['save_license_key'])) {
        // Sanitize the input to ensure it's safe
        $new_license_key = sanitize_text_field($_POST['bogo_for_woocommerce_license_key']);
    
        // Update the option with the new license key
        update_option('bogo_for_woocommerce_validator_key', $new_license_key);
    
    }
    if (isset($_POST['bogo_for_woocommerce_save_settings'])) {
        // Verify the nonce for security
        if (!isset($_POST['bogo_for_woocommerce_settings_nonce']) || !wp_verify_nonce(sanitize_key($_POST['bogo_for_woocommerce_settings_nonce']), 'bogo_for_woocommerce_save_settings_action')) {
            // If the nonce verification fails, display an error and exit
            wp_die('Security check failed. Please try again.');
        }
        $enable_bogo_for_woocommerce = isset($_POST['enable_bogo_for_woocommerce']);
        update_option('enable_bogo_for_woocommerce', $enable_bogo_for_woocommerce);
        // Display a success message
        echo '<div class="updated"><p>Settings saved successfully!</p></div>';
    }
    
    $this->bogo_for_woocommerce_getpremium();  


 wp_nonce_field('bogo_for_woocommerce_save_settings_action', 'bogo_for_woocommerce_settings_nonce');
           echo '  </table><p class="submit">
                <input type="submit" name="bogo_for_woocommerce_save_settings" id="submit" class="button button-primary" value="Save Settings">
            </p>
        </form>
    </div>';

}


function bogo_for_woocommerce_getpremium(){
    $bogo_for_woocommerce_validator_key = get_option('bogo_for_woocommerce_validator_key');
    $response = get_option('check_if_bogo_for_woocommerce_active');
    $bogo_for_woocommerce_repo_version = get_option('bogo_for_woocommerce_repo_version');
   

    // Display the form
    echo '
	  <form class="" action="" method="post" autocomplete="off">
                </form>
    <div class="wrap">
        <h1>General Settings</h1>
        <form method="post" action="">
        
            <table class="form-table">';


    if (trim($response) == "false"&&!$bogo_for_woocommerce_repo_version) {
    // Display the input field for the license key
    echo '
                <tr>
                    <th scope="row"><label for="bogo_for_woocommerce_license_key">Please enter license key:</label></th>
                    <td><input name="bogo_for_woocommerce_license_key" type="text" id="bogo_for_woocommerce_license_key" value="'; 
                    echo esc_attr($bogo_for_woocommerce_validator_key); 
                    echo '" />
                        <input type="submit" name="save_license_key" value="Save" class="button button-primary" />
                    </td>
                </tr>';
              
    update_option('check_if_bogo_for_woocommerce_active', "false");
    } else{
        echo "BOGO is active, open your product settings to set your BOGO offer.";
    }
}

}
