<?php
/**
 * Settings class file.
 *
 * @package WordPress Plugin Template/Settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}





$plugin_dir = plugin_dir_path(__FILE__);
$bogo_for_woocommerce_premium_check = $plugin_dir . 'admin/premium/class-bogo_for_woocommerce-premium-check.php';
$bogo_for_woocommerce_premium_woo = $plugin_dir . 'admin/premium/class-bogo_for_woocommerce-functions-hooks-integration-woocommerce.php';

$settingspage_bogo_for_woocommerce = $plugin_dir . 'admin/class-admin-bogo_for_woocommerce-settingspage.php';
$woocommerce_bogo_for_woocommerce = $plugin_dir . 'integration/class-bogo_for_woocommerce-functions-hooks-integration-woocommerce.php';

include_once $settingspage_bogo_for_woocommerce;
include_once $woocommerce_bogo_for_woocommerce;


if(file_exists($bogo_for_woocommerce_premium_check)){
	include_once $bogo_for_woocommerce_premium_check;
	$bogo_for_woocommerce_activate = new bogo_for_woocommerce_activator();
	$bogo_for_woocommerce_activate->check_if_bogo_for_woocommerce_is_active();
	update_option('bogo_for_woocommerce_repo_version', 0);
	$bogo_for_woocommerce_activation_key = get_option('check_if_bogo_for_woocommerce_active');
    if (trim($bogo_for_woocommerce_activation_key) == "true") {
		include_once $bogo_for_woocommerce_premium_woo;
    }


} else{
	update_option('bogo_for_woocommerce_repo_version', 1);
}
/**
 * Settings class.
 */

class bogo_for_woocommerce_Settings {

	/**
	 * The single instance of bogo_for_woocommerce_Settings.
	 *
	 * @var     object
	 * @access  private
	 * @since   1.0.0
	 */
	private static $_instance = null; //phpcs:ignore

	/**
	 * The main plugin object.
	 *
	 * @var     object
	 * @access  public
	 * @since   1.0.0
	 */
	public $parent = null;

	/**
	 * Prefix for plugin settings.
	 *
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $base = '';

	/**
	 * Available settings for plugin.
	 *
	 * @var     array
	 * @access  public
	 * @since   1.0.0
	 */
	public $settings = array();

	/**
	 * Constructor function.
	 *
	 * @param object $parent Parent object.
	 */
	public function __construct( $parent ) {
		$this->parent = $parent;
		$this->bogo_for_woocommerce_include_files_late();

		$this->base = 'wpt_';

		// Initialise settings.
		add_action( 'init', array( $this, 'init_settings' ), 11 );

		// Register plugin settings.
		add_action( 'admin_init', array( $this, 'register_settings' ) );

		// Add settings page to menu.
		add_action( 'admin_menu', array( $this, 'add_menu_item' ) );

		// Add settings link to plugins page.
		add_filter(
			'plugin_action_links_' . plugin_basename( $this->parent->file ),
			array(
				$this,
				'add_settings_link',
			)
		);

		// Configure placement of plugin settings page. See readme for implementation.
		add_filter( $this->base . 'menu_settings', array( $this, 'configure_settings' ) );
	}
	public function bogo_for_woocommerce_include_files_late() {

		/**
		 * Helper hook to include files late.
		 *
		 */
		do_action( 'bogo_for_woocommerce_include_files_late_action' );

	}
	/**
	 * Initialise settings
	 *
	 * @return void
	 */
	public function init_settings() {
		$this->settings = $this->settings_fields();
	}

	/**
	 * Add settings page to admin menu
	 *
	 * @return void
	 */
	public function add_menu_item() {

		// Get the main menu settings
		$main_menu_args = $this->menu_settings('main');
	
		// Do nothing if wrong location key is set for the main menu.
		if (is_array($main_menu_args) && isset($main_menu_args['location']) && function_exists('add_' . $main_menu_args['location'] . '_page')) {
			switch ($main_menu_args['location']) {
				case 'menu':
					$main_page = add_menu_page(
						$main_menu_args['page_title'],
						$main_menu_args['menu_title'],
						$main_menu_args['capability'],
						$main_menu_args['menu_slug'],
						$main_menu_args['function'],
						$main_menu_args['icon_url'],
						$main_menu_args['position']
					);
					break;
				default:
					return;
			}
	
			// Enqueue assets for the main menu page
			add_action('admin_print_styles-' . $main_page, array($this, 'settings_assets'));
		}
	
	}
	
	/**
	 * Prepare default settings page arguments
	 *
	 * @param string $type Type of menu settings: 'main' or 'submenu'.
	 * @return array The settings array.
	 */
	private function menu_settings($type) {
		$settings = array();

			$settings = array(
				'location'    => 'menu', // Possible settings: options, menu, submenu.
				'parent_slug' => '',
				'page_title'  => __('BOGO', 'BOGO'),
				'menu_title'  => __('BOGO', 'BOGO'),
				'capability'  => 'manage_options',
				'menu_slug'   => $this->parent->_token . '_settings',
				'function'    => array($this, 'settings_page'),
				'icon_url'    => 'data:image/svg+xml;base64,' . base64_encode('<svg width="20" height="20" viewBox="0 0 576 512" xmlns="http://www.w3.org/2000/svg"><path fill="black" d="M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5L488 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288.3 0c-11.5 0-21.4-8.2-23.6-19.5L170.7 288l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3C576.6 57 557.4 32 531.1 32L360 32l0 102.1 23-23c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-64 64c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l23 23L312 32 120.1 32C111 12.8 91.6 0 69.5 0L24 0zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/></svg>'),		
				'position'    => '55',
			);

	
		return apply_filters($this->base . 'menu_settings', $settings);
	}

	/**
	 * Container for settings page arguments
	 *
	 * @param array $settings Settings array.
	 *
	 * @return array
	 */
	public function configure_settings( $settings = array() ) {
		return $settings;
	}

	/**
	 * Load settings JS & CSS
	 *
	 * @return void
	 */
	public function settings_assets() {

		// We're including the farbtastic script & styles here because they're needed for the colour picker
		// If you're not including a colour picker field then you can leave these calls out as well as the farbtastic dependency for the wpt-admin-js script below.
		wp_enqueue_style( 'farbtastic' );
		wp_enqueue_script( 'farbtastic' );

		// We're including the WP media scripts here because they're needed for the image upload field.
		// If you're not including an image upload then you can leave this function call out.
		wp_enqueue_media();

		wp_register_script( $this->parent->_token . '-settings-js', $this->parent->assets_url . 'js/settings' . $this->parent->script_suffix . '.js', array( 'farbtastic', 'jquery' ), '1.0.0', true );
		wp_enqueue_script( $this->parent->_token . '-settings-js' );
	}

	/**
	 * Add settings link to plugin list table
	 *
	 * @param  array $links Existing links.
	 * @return array        Modified links.
	 */
	public function add_settings_link( $links ) {
		$settings_link = '<a href="options-general.php?page=' . $this->parent->_token . '_settings">' . __( 'Settings', 'bogo_for_woocommerce' ) . '</a>';
		array_push( $links, $settings_link );
		return $links;
	}

	/**
	 * Build settings fields
	 *
	 * @return array Fields to be displayed on settings page
	 */
	private function settings_fields() {
		

		$settings['Settings'] = array(
			'title'       => __( 'Settings', 'bogo_for_woocommerce' ),
		);






		$settings['My-Offers'] = array(
			'title'       => __( 'My Offers', 'bogo_for_woocommerce' ),
		);



		$settings['Excluded-Items'] = array(
			'title'       => __( 'Excluded Items', 'bogo_for_woocommerce' ),
		);






		

		$settings = apply_filters( $this->parent->_token . '_settings_fields', $settings );

		return $settings;
	}

	/**
	 * Register plugin settings
	 *
	 * @return void
	 */
	public function register_settings() {
		if ( is_array( $this->settings ) ) {

			// Check posted/selected tab.
			//phpcs:disable
			$current_section = '';
			if ( isset( $_POST['tab'] ) && $_POST['tab'] ) {
				$current_section = sanitize_text_field($_POST['tab']);
			} else {
				if ( isset( $_GET['tab'] ) && $_GET['tab'] ) {
					$current_section = sanitize_text_field($_GET['tab']);
				}
			}
			//phpcs:enable

			foreach ( $this->settings as $section => $data ) {

				if ( $current_section && $current_section !== $section ) {
					continue;
				}

				// Add section to page.
				add_settings_section( $section, $data['title'], array( $this, 'settings_section' ), $this->parent->_token . '_settings' );
				if (isset($data['fields']) && is_array($data['fields'])) {
				foreach ( $data['fields'] as $field ) {

					// Validation callback for field.
					$validation = '';
					if ( isset( $field['callback'] ) ) {
						$validation = $field['callback'];
					}

					// Register field.
					$option_name = $this->base . $field['id'];
					register_setting(
						$this->parent->_token . '_settings',
						$option_name,
						array(
						'sanitize_callback' => $validation
						)
					);


					// Add field to page.
					add_settings_field(
						$field['id'],
						$field['label'],
						array( $this->parent->admin, 'display_field' ),
						$this->parent->_token . '_settings',
						$section,
						array(
							'field'  => $field,
							'prefix' => $this->base,
						)
					);
				}}

				if ( ! $current_section ) {
					break;
				}
			}
		}
	}

	/**
	 * Settings section.
	 *
	 * @param array $section Array of section ids.
	 * @return void
	 */
	public function settings_section( $section ) {
		$html = '<p> ' . esc_html($this->settings[ $section['id'] ]['description']) . '</p>' . "\n";
		echo wp_kses_post($html);

	}

	/**
	 * Load settings page content.
	 *
	 * @return void
	 */
	public function settings_page() {

		$bogo_for_woocommerceettings = new bogo_for_woocommerce_settingspage();

		// Build page HTML.
		$html      = '<div class="wrap" id="' . $this->parent->_token . '_settings">' . "\n";
			$html .= '<h2>' . __( 'BOGO', 'bogo_for_woocommerce' ) . '</h2>' . "\n";

			$tab = '';
		//phpcs:disableif($tab != "BOGO"){
	
		//phpcs:enable
		
		// Show page tabs. if($tab != "BOGO"){
		if ( is_array( $this->settings ) && 1 < count( $this->settings ) ) {

			$html .= '<h2 class="nav-tab-wrapper">' . "\n";

			$c = 0;
			foreach ( $this->settings as $section => $data ) {

				// Set tab class.
				$class = 'nav-tab';
				if ( ! isset( $_GET['tab'] ) ) { //phpcs:ignore
					if ( 0 === $c ) {
						$class .= ' nav-tab-active';
					}
				} else {
					if ( isset( $_GET['tab'] ) && $section == $_GET['tab'] ) { //phpcs:ignore
						$class .= ' nav-tab-active';
					}
				}

				// Set tab link.
				$tab_link = add_query_arg( array( 'tab' => $section ) );
				if ( isset( $_GET['settings-updated'] ) ) { //phpcs:ignore
					$tab_link = remove_query_arg( 'settings-updated', $tab_link );
				}
				if($section != "My-Offers" && $section != "BOGO-Settings" && $section != "Excluded-Items"){
				// Output tab.
				$html .= '<a href="' . $tab_link . '" class="' . esc_attr( $class ) . '">' . esc_html( $data['title'] ) . '</a>' . "\n";
				}
				++$c;
				
			}

			$html .= '</h2>' . "\n";
		}
	

			$html .= '<form method="post" action="options.php" enctype="multipart/form-data">' . "\n";

				// Get settings fields.
				ob_start();
				settings_fields( $this->parent->_token . '_settings' );

				if (empty($tab)) {
					$tab = 'Settings';
				}
				$html .= $this->bogo_for_woocommerce_handle_tab_specific_bogo($tab, $bogo_for_woocommerceettings);


				$html .= ob_get_clean();

				$html     .= '<p class="submit">' . "\n";
					$html .= '<input type="hidden" name="tab" value="' . esc_attr( $tab ) . '" />' . "\n";
					
				$html     .= '</p>' . "\n";
			$html         .= '</form>' . "\n";
		$html             .= '</div>' . "\n";


		
		$default_allowed_html = wp_kses_allowed_html('post');
                                                                                                                                                                                                              
		$custom_allowed_html = array(
			'form' => array(
				'class' => array(),
				'action' => array(),
				'method' => array(),
				'autocomplete' => array(),
			),
			'div' => array(
				'class' => array(),
			),
			'h1' => array(),
			'h3' => array(),
			'table' => array(
				'class' => array(),
			),
			'tr' => array(),
			'th' => array(
				'scope' => array(),
				'colspan' => array(), // If you need colspan
			),
			'td' => array(),
			'label' => array(
				'for' => array(),
			),
			'input' => array(
				'name' => array(),
				'type' => array(),
				'id' => array(),
				'value' => array(),
				'class' => array(),
				'checked' => array(),
				'placeholder' => array(), // Add this if placeholders are used
			),
			'span' => array(
				'id' => array(),
			),
			'p' => array(
				'class' => array(),
			),
			'button' => array(
				'type' => array(),
				'class' => array(),
				'id' => array(),
			),
		);
		
																																																				   
                                                                                                                                                                                                              
$allowed_html = array_merge_recursive($default_allowed_html, $custom_allowed_html);
echo wp_kses($html, $allowed_html); //phpcs:ignore
	}



	private function bogo_for_woocommerce_handle_tab_specific_bogo($tab, $bogo_for_woocommerceettings) {
		$html = '';
	
		//switchcase to see which tab is active and opening the method in the tab as html
		switch ($tab){
			case 'Settings':
				$html .= $bogo_for_woocommerceettings->bogo_for_woocommerce_display_button_text_settings();
				break;

		}
	
		return $html;
	}





	/**
	 * Main bogo_for_woocommerce_Settings Instance
	 *
	 * Ensures only one instance of bogo_for_woocommerce_Settings is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @see bogo_for_woocommerce()
	 * @param object $parent Object instance.
	 * @return object bogo_for_woocommerce_Settings instance
	 */
	public static function instance( $parent ) {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self( $parent );
		}
		return self::$_instance;
	} // End instance()



}
